// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float2 R:TARGETSIZE;

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
float Size;
bool outline;
float4 Col1 <bool color=true;> ={0.94,0.3,0.0,1.0};
float4 Col2 <bool color=true;> ={0.1,0.4,0.8,1.0};	
};

struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
   float2 uv = -1.0 + 2.0*In.TexCd.xy;
	uv.y=1-In.TexCd.y;
	//uv.x *=  R.x / R.y;

    // background	 
	float3 color = float(0.8 + 0.2*uv.y);

    // bubbles	
	for( int i=0; i<40; i++ )
	{
        // bubble seeds
		float pha =      sin(float(i)*546.13+1.0)*0.5 + 0.5;
		float siz = pow( sin(float(i)*651.74+5.0)*0.5 + 0.5, 4.0 );
		float pox =      sin(float(i)*321.55+4.1) * R.x / R.y;

        // buble size, position and color
		float rad = 0.1 + 0.5*siz+Size;
		float2  pos = float2( pox, -1.0-rad + (2.0+2.0*rad)*fmod(pha+0.1*time*(0.2+0.8*siz),1.0));
		float dis = length( uv - pos );
		float4  col = lerp( Col1, Col2, 0.5+0.5*sin(float(i)*1.2+1.9));
		if(outline) col+= 8.0*smoothstep( rad*0.95, rad, dis );
		
        // render
		float f = length(uv-pos)/rad;
		f = sqrt(clamp(1.0-f*f,0.0,1.0));
		color -= col.zyx *(1.0-smoothstep( rad*0.95, rad, dis )) * f;
	}

    // vigneting	
	color *= sqrt(1.5-0.5*length(uv));
	return float4(color,1.0);
}


technique10 Bubble
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



