// Created by inigo quilez - iq/2014
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

//-----------------------------------------------------------------------------------
float2 R:TARGETSIZE;
Texture2D tex0 <string uiname="iChannel0";>;
Texture2D tex1 <string uiname="iChannel1";>;
Texture2D tex2 <string uiname="iChannel2";>;
Texture2D tex3 <string uiname="iChannel3";>;

SamplerState s0 
{
	Filter = MIN_MAG_MIP_LINEAR;
	AddressU = wrap;
	AddressV = wrap;
};

cbuffer cbPerDraw : register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
float2 rotate;
};


struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
};

struct vs2ps
{
	float4 PosWVP:SV_POSITION;
	float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
	vs2ps output;
	output.PosWVP = mul(input.PosO,mul(tW,tVP));
	output.TexCd = input.TexCd;
	return output;
}


//-----------------------------------------------------------------------------------

//#define FULL_PROCEDURAL
#define LOWDETAIL
//#define HIGH_QUALITY_NOISE

#ifdef FULL_PROCEDURAL
float hash( float n )
{
	return frac(sin(n)*43758.5453);
}

float noise1( in float3 x )
{
	float3 p = floor(x);
	float3 f = frac(x);
	
	f = f*f*(3.0-2.0*f);
	float n = p.x + p.y*57.0 + 113.0*p.z;
	return lerp(lerp(lerp( hash(n+  0.0), hash(n+  1.0),f.x),
	lerp( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y),
	lerp(lerp( hash(n+113.0), hash(n+114.0),f.x),
	lerp( hash(n+170.0), hash(n+171.0),f.x),f.y),f.z);
}

#else
float noise1( in float3 x )
{
	float3 p = floor(x);
	float3 f = frac(x);
	f = f*f*(3.0-2.0*f);
#ifndef HIGH_QUALITY_NOISE
	float2 uv = (p.xy+float2(37.0,17.0)*p.z) + f.xy;
	float2 rg = tex2.SampleLevel( s0, (uv+ 0.5)/256.0, -100.0 ).yx;
#else
	float2 uv = (p.xy+float2(37.0,17.0)*p.z);
	float2 rg1 = tex2.SampleLevel( s0, (uv+ float2(0.5,0.5))/256.0, -100.0 ).yx;
	float2 rg2 = tex2.SampleLevel( s0, (uv+ float2(1.5,0.5))/256.0, -100.0 ).yx;
	float2 rg3 = tex2.SampleLevel( s0, (uv+ float2(0.5,1.5))/256.0, -100.0 ).yx;
	float2 rg4 = tex2.SampleLevel( s0, (uv+ float2(1.5,1.5))/256.0, -100.0 ).yx;
	float2 rg = lerp( lerp(rg1,rg2,f.x), lerp(rg3,rg4,f.x), f.y );
#endif
	return lerp( rg.x, rg.y, f.z );
}
#endif
//-----------------------------------------------------------------------------------
float3x3 m = float3x3( 0.00,  0.80,  0.60,
					  -0.80,  0.36, -0.48,
					  -0.60, -0.48,  0.64 );

float displacement( float3 p )
{
	float f;
	f  = 0.5000*noise1( p ); p = mul(m , p * 2.02);
	f += 0.2500*noise1( p ); p = mul(m , p * 2.03);
	f += 0.1250*noise1( p ); p = mul(m , p * 2.01);
	#ifndef LOWDETAIL
	f += 0.0625*noise1( p );
	#endif
	return f;
}

float4 texcube( Texture2D tex0, in float3 p, in float3 n )
{
	float4 x = tex0.Sample( s0, p.yz);
	float4 y = tex0.Sample( s0, p.zx );
	float4 z = tex0.Sample( s0, p.xy );
	return (x*abs(n.x) + y*abs(n.y) + z*abs(n.z))/(abs(n.x)+abs(n.y)+abs(n.z));
}

float4 texture2DGood( Texture2D tex0, float2 uv, float bias )
{
	uv = uv*1024.0 - 0.5;
	float2 iuv = floor(uv);
	float2 f = frac(uv);
	float4 rg1 = tex0.SampleLevel( s0, (iuv+ float2(0.5,0.5))/1024.0, bias );
	float4 rg2 = tex0.SampleLevel( s0, (iuv+ float2(1.5,0.5))/1024.0, bias );
	float4 rg3 = tex0.SampleLevel( s0, (iuv+ float2(0.5,1.5))/1024.0, bias );
	float4 rg4 = tex0.SampleLevel( s0, (iuv+ float2(1.5,1.5))/1024.0, bias );
	return lerp( lerp(rg1,rg2,f.x), lerp(rg3,rg4,f.x), f.y );
}
//-----------------------------------------------------------------------------------



float terrain( in float2 q )
{
	float th = smoothstep( 0.0, 0.7, tex0.SampleLevel( s0, 0.001*q, -100.0 ).x );
	float rr = smoothstep( 0.1, 0.5, tex1.SampleLevel( s0, 2.0*0.03*q, -100.0 ).y );
	float h = 1.9;
	#ifndef LOWDETAIL
	h += (1.0-0.6*rr)*(1.5-1.0*th) * 0.2*(1.0-tex0.SampleLevel( s0, 0.03*q, -100.0 ).x);
	#endif
	h += th*7.0;
	h += 0.3*rr;
	return -h;
}

float terrain2( in float2 q )
{
	float th = smoothstep( 0.0, 0.7, texture2DGood( tex0, 0.001*q, -100.0 ).x );
	float rr = smoothstep( 0.1, 0.5, texture2DGood( tex1, 2.0*0.03*q, -100.0 ).y );
	float h = 1.9;
	h += th*7.0;
	return -h;
}


float4 map( in float3 p )
{
	float h = terrain( p.xz );
	float dis = displacement( 0.25*p*float3(1.0,4.0,1.0) );
	dis *= 3.0;
	return float4( (dis + p.y-h)*0.25, p.x, h, 0.0 );
}

float4 intersect( in float3 ro, in float3 rd )
{
	const float maxd = 120.0;
	const float precis = 0.001;
	float h = precis*3.0;
	float t = 0.0;
	float m = 0.0;
	float l = 0.0;
	float r = 0.0;
	for( int i=0; i<180; i++ )
	{
		//if( h>precis && t<maxd )
		if( h<precis || t>maxd ) break;
		{
			t += h *(1.0+0.007*t);
			float4 res = map( ro+rd*t );
			h = res.x;
			l = res.y;
			r = res.z;
			m = res.w;
		}
	}
	
	if( t>maxd ) m=-1.0;
	return float4( t, l, m, r);
}

float3 calcNormal( in float3 pos )
{
	const float3 eps = float3(0.01,0.0,0.0);
	return normalize( float3(
	map(pos+eps.xyy).x - map(pos-eps.xyy).x,
	map(pos+eps.yxy).x - map(pos-eps.yxy).x,
	map(pos+eps.yyx).x - map(pos-eps.yyx).x ) );
}

float softshadow( in float3 ro, in float3 rd, float mint, float k )
{
	float res = 1.0;
	float t = mint;
	float h = 1.0;
	float4 hm;
		for( int i=0; i<64; i++ )
	{
		hm = map(ro + rd * t);
		h = hm.x;
		res = min( res, k*h/t );
		t += clamp( h, 0.3, 1.0 );
}
	return clamp(res,0.0,1.0);
}

// Oren-Nayar
float Diffuse( in float3 l, in float3 n, in float3 v, float r )
{
	
	float r2 = r*r;
	float a = 1.0 - 0.5*(r2/(r2+0.57));
	float b = 0.45*(r2/(r2+0.09));
	
	float nl = dot(n, l);
	float nv = dot(n, v);
	
	float ga = dot(v-n*nv,n-n*nl);
	
	return max(0.0,nl) * (a + b*max(0.0,ga) * sqrt((1.0-nv*nv)*(1.0-nl*nl)) / max(nl, nv));
}

float3 cpath( float t )
{
	float3 pos = float3( 0.0, 0.0, 95.0 + t );
	
	float a = smoothstep(5.0,20.0,t);
	pos.xz += a*150.0 * cos( float2(5.0,6.0) + 1.0*0.01*t );
	pos.xz -= a*150.0 * cos( float2(5.0,6.0) );
	pos.xz += a* 50.0 * cos( float2(0.0,3.5) + 6.0*0.01*t );
	pos.xz -= a* 50.0 * cos( float2(0.0,3.5) );
	
	return pos;
}


float4 PSCanyon(vs2ps In): SV_Target
{
	float2 p = In.TexCd.rg;
	
	float2 q = In.TexCd.xy;
	 p = -1.0 + 2.0 * q;
	p.x *= R.x/R.y;
	
	q = 1 -In.TexCd.rg;
	p = -1.0 + 2.0*q;
	p.x *= R.x / R.y;
	float2 mo = -1.0 + 2.0*rotate.xy ;
	
	float2 m = float2(0.0, 0.0 );
	m = rotate.xy;
	
	
	
	//-----------------------------------------------------
	// camera
	//-----------------------------------------------------
	
	float an = 0.5*(time-5.0);// + 12.0*(m.x-0.5);
	float3 ro = cpath( an + 0.0 );
	float3 ta = cpath( an + 10.0 *1.0);
	ta = lerp( ro + float3(0.0,0.0,1.0), ta, smoothstep(5.0,25.0,an) );
	ro.y = terrain2( ro.xz ) - 0.5;
	ta.y = ro.y - 0.1;
	ta.xy += step(0.01,m.x)*(m.xy-0.5)*4.0*float2(-1.0,1.0);
	
	// camera matrix/ray
	float rl = -0.1*cos(0.05*6.2831*an);
	float3 ww = normalize( ta - ro );
	float3 uu = normalize( cross(ww,float3(sin(rl),cos(rl),0.0) ) );
	float3 vv = normalize( cross(uu,ww));
	float3 rd = normalize( p.x*uu + p.y*vv + 2.0*ww );
	
	//-----------------------------------------------------
	// render
	//-----------------------------------------------------
	
	float3 klig = normalize(float3(-1.0,0.19,0.4));
	//klig = float3( cos(m.y)*cos(3.0*m.x), sin(m.y), cos(m.y)*sin(3.0*m.x) );
	
	float sun = clamp(dot(klig,rd),0.0,1.0 );
	
	float3 hor = lerp( 1.2*float3(0.70,1.0,1.0), float3(1.5,0.5,0.05), 0.25+0.75*sun );
	
	float3 col = lerp( float3(0.2,0.6,.9), hor, exp(-(4.0+2.0*(1.0-sun))*max(0.0,rd.y-0.1)) );
	col *= 0.5;
	col += 0.8*float3(1.0,0.8,0.7)*pow(sun,512.0);
	col += 0.2*float3(1.0,0.4,0.2)*pow(sun,32.0);
	col += 0.1*float3(1.0,0.4,0.2)*pow(sun,4.0);
	
	float3 bcol = col;
	
	// clouds
	float pt = (1000.0-ro.y)/rd.y;
	if( pt>0.0 )
	{
		float3 spos = ro + pt*rd;
		float clo = tex0.Sample( s0, 0.00006*spos.xz ).x;
		clo = tex0.Sample( s0, 0.00006*spos.xz ).x;
		float3 cloCol = lerp( float3(0.4,0.5,0.6), float3(1.3,0.6,0.4), pow(sun,2.0))*(0.5+0.5*clo);
		col = lerp( col, cloCol, 0.5*smoothstep( 0.4, 1.0, clo ) );
	}
	
	
	// raymarch
	float4 tmat = intersect(ro,rd);
	if( tmat.z>-0.5 )
	{
		// geometry
		float3 pos = ro + tmat.x*rd;
		float3 nor = calcNormal(pos);
		float3 ref = reflect( rd, nor );
		
		
		float occ = smoothstep( 0.0, 1.5, pos.y + 11.5 ) * (1.0 - displacement( 0.25*pos*float3(1.0,4.0,1.0) ));
		
		// materials
		float4 mate = float4(0.5,0.5,0.5,0.0);
		
		//if( tmat.z<0.5 )
		{
			float3 uvw = 1.0*pos;
			
			float3 bnor;
			float be = 1.0/1024.0;
			float bf = 0.4;
			bnor.x = texcube( tex0, bf*uvw+float3(be,0.0,0.0), nor ).x - texcube( tex0, bf*uvw-float3(be,0.0,0.0), nor ).x;
			bnor.y = texcube( tex0, bf*uvw+float3(0.0,be,0.0), nor ).x - texcube( tex0, bf*uvw-float3(0.0,be,0.0), nor ).x;
			bnor.z = texcube( tex0, bf*uvw+float3(0.0,0.0,be), nor ).x - texcube( tex0, bf*uvw-float3(0.0,0.0,be), nor ).x;
			bnor = normalize(bnor);
			float amo = 0.2  + 0.25*(1.0-smoothstep(0.6,0.7,nor.y) );
			nor = normalize( nor + amo*(bnor-nor*dot(bnor,nor)) );
			
			float3 te = texcube( tex0, 0.15*uvw, nor ).xyz;
			te = 0.05 + te;
			mate.xyz = 0.6*te;
			mate.w = 1.5*(0.5+0.5*te.x);
			float th = smoothstep( 0.1, 0.4, texcube( tex0, 0.002*uvw, nor ).x );
			float3 dcol = lerp( float3(0.2, 0.3, 0.0), 0.4*float3(0.65, 0.4, 0.2), 0.2+0.8*th );
			mate.xyz = lerp( mate.xyz, 2.0*dcol, th*smoothstep( 0.0, 1.0, nor.y ) );
			mate.xyz *= 0.5;
			float rr = smoothstep( 0.2, 0.4, texcube( tex1, 2.0*0.02*uvw, nor ).y );
			mate.xyz *= lerp( float3(1.0, 1.0, 1.0), 1.5*float3(0.25,0.24,0.22)*1.5, rr );
			mate.xyz *= 1.5 * pow(texcube( tex3, 8.0* uvw, nor ).xyz, float3(0.5, 0.5, 0.5));
			mate = lerp( mate, float4(0.7,0.7,0.7,.0), smoothstep(0.8,0.9,nor.y + nor.x*0.6*te.x*te.x ));
			
			
			mate.xyz *= 1.5;
		}
		
		float3 blig = normalize(float3(-klig.x,0.0,-klig.z));
		float3 slig = float3( 0.0, 1.0, 0.0 );
		
		// lighting
		float sky = 0.0;
		sky += 0.2*Diffuse( normalize(float3( 0.0, 1.0, 0.0 )), nor, -rd, 1.0 );
		sky += 0.2*Diffuse( normalize(float3( 3.0, 1.0, 0.0 )), nor, -rd, 1.0 );
		sky += 0.2*Diffuse( normalize(float3(-3.0, 1.0, 0.0 )), nor, -rd, 1.0 );
		sky += 0.2*Diffuse( normalize(float3( 0.0, 1.0, 3.0 )), nor, -rd, 1.0 );
		sky += 0.2*Diffuse( normalize(float3( 0.0, 1.0,-3.0 )), nor, -rd, 1.0 );
		float dif = Diffuse( klig, nor, -rd, 1.0 );
		float bac = Diffuse( blig, nor, -rd, 1.0 );
		
		
		float sha = 0.0; if( dif>0.001 ) sha=softshadow( pos+0.01*nor, klig, 0.005, 64.0 );
		float spe = mate.w*pow( clamp(dot(reflect(rd,nor),klig),0.0,1.0),2.0)*clamp(dot(nor,klig),0.0,1.0);
		
		// lights
		float3 lin = float3(0.0, 0.0, 0.0);
		lin += 7.0*dif*float3(1.40,0.50,0.25)*float3(sha,sha*0.5+0.5*sha*sha, sha*sha );
		lin += 1.0*sky*float3(0.10,0.50,0.70)*occ;
		lin += 2.0*bac*float3(0.30,0.15,0.15)*occ;
		lin += 0.5*float3(spe, spe, spe)*sha*occ;
		
		// surface-light interacion
		col = mate.xyz * lin;
		
		// fog
		bcol = 0.7*lerp( float3(0.2,0.5,1.0)*0.82, bcol, 0.15+0.8*sun ); 
		col = lerp( col, bcol, 1.0-exp(-0.02*tmat.x) );
	}
	
	
	col += 0.15*float3(1.0,0.9,0.6)*pow( sun, 6.0 );
	
	//-----------------------------------------------------
	// postprocessing
	//-----------------------------------------------------
	
	col *= 1.0 - 0.25*pow(1.0-clamp(dot(ww,klig),0.0,1.0),3.0);
	
	col = pow( clamp(col,0.0,1.0), float3(0.45, 0.45, 0.45) );
	
	col *= float3(1.1,1.0,1.0);
	col = col*col*(3.0-2.0*col);
	col = pow( col, float3(0.9,1.0,1.0) );
	
	col = lerp( col, float(dot(col, float3(0.333, 0.333, 0.333) ) ), 0.4);
	float3 d = dot(col, float3(0.333, 0.333, 0.333) ) ;
	col = lerp( col, d, 0.4);
	col = col*0.3+0.7*col*col*(3.0-2.0*col);
	
	col *= 0.3 + 0.7*pow( abs(16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y)), 0.1 );
	
	col *= smoothstep(0.0,2.5,time);
	
	return  float4( col, 1.0 );
	
	
}


technique10 Canyon
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PSCanyon()));
	}
}






