// Author @patriciogv - 2015
// http://patriciogonzalezvivo.com

float2 R:TARGETSIZE;

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
float2 mouse;
};

float random (in float x)
{
    return frac(sin(x)*1e4);
}

float random (in float2 st) 
{
    return frac(sin(dot(st.xy, float2(12.9898,78.233)))* 43758.5453123);
}

float pattern(float2 st, float2 v, float t) {
    float2 p = floor(st+v);
    return step(t, random(100.+p*.000001)+random(p.x)*0.5 );
}


struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
	float2 st = In.TexCd.xy;
	st.y=1-In.TexCd.y;
    st.x *= R.x/R.y;

    float2 grid = float2(100.0,50.);
    st *= grid;
    
    float2 ipos = floor(st);  // integer
    float2 fpos = frac(st);  // fraction
    
    float2 vel = float(time*2.*max(grid.x,grid.y)); // time
    vel *= float2(-1.,0.0) * random(1.0+ipos.y); // direction

    // Assign a random value base on the integer coord
    float2 offset = float2(0.1,0.);

    float3 color = float(0.);
    color.r = pattern(st+offset,vel,0.5+mouse.x/R.x);
    color.g = pattern(st,vel,0.5+mouse.x/R.x);
    color.b = pattern(st-offset,vel,0.5+mouse.x/R.x);

    // Margins
    color *= step(0.2,fpos.y);

    return float4(color,1.0);

}


technique10 DataPath
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



