
float2 R:TARGETSIZE;

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float moveSpeed=0.75;
float time;
};

#define MOTIONBLUR_EMBERS 	0 // Set to 1 to enable sampled motion blur on the embers.
#define ADD_HEAT_GLOW 		0 // Set to 1 to make the rock glow red as the lava covers it.


float cubic(float x)
{
    return (3.0 * x - 2.0 * x * x) * x;
}

float3 rotateX(float angle, float3 v)
{
    return float3(v.x, cos(angle) * v.y + sin(angle) * v.z, cos(angle) * v.z - sin(angle) * v.y);
}

float3 rotateY(float angle, float3 v)
{
    return float3(cos(angle) * v.x + sin(angle) * v.z, v.y, cos(angle) * v.z - sin(angle) * v.x);
}

float hash(float n)
{
    n=fmod(n,1024.0);
    return frac(sin(n)*43758.5453);
}

float noise(float2 p)
{
    return hash(p.x + p.y*57.0);
}

float smoothNoise2(float2 p)
{
    float2 p0 = floor(p + float2(0.0, 0.0));
    float2 p1 = floor(p + float2(1.0, 0.0));
    float2 p2 = floor(p + float2(0.0, 1.0));
    float2 p3 = floor(p + float2(1.0, 1.0));
    float2 pf = frac(p);
    return lerp( lerp(noise(p0), noise(p1), pf.x),lerp(noise(p2), noise(p3), pf.x), pf.y);
}

float cellnoise(float2 p)
{
    float2 fp=frac(p);
    float2 ip=p-fp;
    float nd=1e3;
    float2 nc=p;
    for(int i=-1;i<2;i+=1)
        for(int j=-1;j<2;j+=1)
        {
            float2 c=ip+float2(i,j)+float2(noise(ip+float2(i,j)),noise(ip+float2(i+10,j)));
            float d=distance(c,p);
            if(d<nd)
            {
                nd=d;
                nc=c;
            }
        }

    return nd;
}

float heightField(float2 p)
{
    float f=0.0;
    for(int i=0;i<3;i+=1)
        f+=smoothNoise2(p*exp2(float(i+2)))/exp2(float(i));
    return smoothstep(0.0,0.7,1.0-smoothstep(0.0,0.9,cellnoise(p)))*0.4+f*0.04;
}


float fbm(float2 p)
{
    float f=0.0;
    for(int i=0;i<4;i+=1)
        f+=smoothNoise2(p*exp2(float(i)))/exp2(float(i+1));
    return f;
}

float bumpHeight(float2 p)
{
    float f=0.0;
    p*=4.0;
    for(int i=0;i<5;i+=1)
        f+=smoothNoise2(p*exp2(float(i)))/exp2(float(i+1));
    return f*0.15;
}

float3 bumpNormal(float2 p)
{
    float2 eps=float2(1e-5,0.0);
    float bumpScale=10.0;
    float c=bumpHeight(p);
    float d0=(bumpHeight(p+eps.xy))-c;
    float d1=(bumpHeight(p+eps.yx))-c;
    return normalize(cross(float3(eps.y,d1,eps.x),float3(eps.x,d0,eps.y)));
}

float3 heightFieldNormal(float2 p)
{
    float2 eps=float2(1e-1,0.0);
    float bumpScale=10.0;
    float c=heightField(p);
    float d0=(heightField(p+eps.xy))-c;
    float d1=(heightField(p+eps.yx))-c;
    float3 n0 = normalize(cross(float3(eps.y,d1,eps.x),float3(eps.x,d0,eps.y)));
    float3 bn = bumpNormal(p);
    return normalize(n0+(bn-n0*dot(n0,bn))*0.2);
}

float3 tonemap(float3 c)
{
    return c/(c+float(0.6));
}

float evalLavaHeight(float2 p)
{
    return lerp(-0.5,0.2,cubic(clamp(1.0-(-p.y-time*moveSpeed)+sin(p.x+time*0.2),0.0,1.0)));
}

float3 sample(float2 coord)
{
    // Set up ray.
    float3 ro=float3(0.0,3.0,-2.0-time*moveSpeed+cos(time*1.0)*0.05);
    float3 rd=rotateY(3.1415926+sin(time*0.1),rotateX(1.0+sin(time*0.4)*0.05,normalize(float3(coord,-1.3))));

    // Intersect the ray with the upper and lower planes of the heightfield.
    float t0=(0.5-ro.y)/rd.y;
    float t1=(0.0-ro.y)/rd.y;

    const int n=14;

    float lavaHeight=0.0;

    float3 prevp=ro+rd*t0,p=prevp;
    float ph=heightField(prevp.xz);

    // Raymarch through the heightfield with a fixed number of steps.
    for(int i=1;i<n;i+=1)
    {
        float pt=lerp(t0,t1,float(i-1)/float(n));
        float t=lerp(t0,t1,float(i)/float(n));
        p=ro+rd*t;
        lavaHeight=evalLavaHeight(p.xz);
        float h=max(lavaHeight,heightField(p.xz));
        if(h>p.y)
        {
            // Refine the intersection point.
            float lrd=length(rd.xz);
            float2 v0=float2(lrd*pt, prevp.y);
            float2 v1=float2(lrd*t, p.y);
            float2 v2=float2(lrd*pt, ph);
            float2 dv=float2(h-v2.y,v2.x-v1.x);
            float inter=dot(v2-v0,dv)/dot(v1-v0,dv);
            p=lerp(prevp,p,inter);

            // Re-evaluate the lava height using the refined intersection point.
            lavaHeight=evalLavaHeight(p.xz);
            break;
        }
        prevp=p;
        ph=h;
    }

    float3 norm=heightFieldNormal(p.xz);

    // Base colour for the rocks.
    float f0=sqrt(fbm(p.xz*0.5));
    float3 diffuse=lerp(float3(0.1,0.2,0.1)*0.5,lerp(float(0.1),float3(1.0,0.8,0.6)*0.3,f0),max(0.0,norm.y))*lerp(0.7,0.2,p.y)*lerp(0.3,1.0,fbm(p.xz*3.0));

    // Cheating by simply adding light from the lava into the diffuse albedo.
    diffuse+=float3(1.0,0.35,0.04)*clamp((1.0-norm.y)*0.1+pow(max(0.0,(1.0-abs(lavaHeight-p.y)*4.0)),2.0),0.0,1.0)*0.4;
    diffuse=lerp(1.5*float3(1.0,0.35,0.04),diffuse,clamp((p.y-lavaHeight)*16.0,0.0,1.0));
    
#if ADD_HEAT_GLOW
    float3 glow=smoothstep(0.0,3.0,p.z+time*moveSpeed)*max(0.0,1.0-p.y*1.5)*pow(3.0*float3(0.4,0.21,0.1)*(0.6*fbm(p.xz+float2(time*0.5,0.0))+0.6*fbm(p.xz+float2(-time*0.5,0.0))),float(3.0));
#else
    float3 glow=float(0.0);
#endif
    
    // Some small bright bits for fake embers to suggest fire.
#if MOTIONBLUR_EMBERS
    float3 embers=float(0.0);
    for(int j=0;j<8;j+=1)
    {
        float mb_time=time+float(j)*6e-2/8.0;
	    embers+=float3(1.0,0.35,0.04)*smoothstep(0.77+sin(mb_time*20.0)*0.01+sin(mb_time)*0.01,1.0,fbm(coord*10.0+float2(cos(coord.y*0.8+mb_time*0.7)*10.0,mb_time*4.0)));
    	embers+=float3(1.0,0.35,0.04)*smoothstep(0.77+sin(mb_time*22.0)*0.01+sin(mb_time*1.2)*0.01,1.0,fbm(float(100.0)+coord*8.0+float2(mb_time*8.0+cos(coord.y*0.3+mb_time*0.3)*10.0,mb_time*7.0)));
    }
    embers/=8.0*0.5;
#else
    float3 embers=float3(1.0,0.35,0.04)*smoothstep(0.77+sin(time*20.0)*0.01+sin(time)*0.01,1.0,fbm(coord*10.0+float2(cos(coord.y*0.8+time*0.7)*10.0,time*4.0)));
    embers+=float3(1.0,0.35,0.04)*smoothstep(0.77+sin(time*22.0)*0.01+sin(time*1.2)*0.01,1.0,fbm(float(100.0)+coord*8.0+float2(time*8.0+cos(coord.y*0.3+time*0.3)*10.0,time*7.0)));
#endif
    
    // Wrap lighting is applied here, both to the rock, lava, and glow from lava. This is not correct, but
    // it gives some substance to the lava and variation/shadow to the glow.
    return diffuse*(0.5+0.5*norm.x)*2.5+float3(1.0,0.35,0.04)*0.02+embers+glow;
}


struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
   // Sample the scene, with a distorted coordinate to simulate heat haze.
    float2 uv = In.TexCd.xy;
	uv.y=1-In.TexCd.y;
    uv = (uv - float(0.5)) * 2.0;
    uv.x *= R.x / R.y;
	
	float4 color;
    color.rgb=sample(uv+float2(cos(smoothNoise2(float2(-time*10.0+uv.y*10.0,uv.x)))*0.01,0.0));
    color.rgb=tonemap(color.rgb)*1.2;
	return color;

}


technique10 lava
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



