// Created by inigo quilez - iq/2015
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float2 R:TARGETSIZE;

cbuffer cbPerDraw : register( b0 ){
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
};

Texture2D tex0:PREVIOUS;
SamplerState s0  <bool visible=false;string uiname="Sampler";> 
{
	Filter=MIN_MAG_MIP_LINEAR;
	AddressU=CLAMP;
	AddressV=CLAMP;
};

struct vs2ps
{
	float4 PosWVP:SV_POSITION;
	float4 TexCd:TEXCOORD0;
};

vs2ps VS(float4 PosO:POSITION, float4 TexCd:TEXCOORD0)
{
	vs2ps output;
	output.PosWVP = mul(PosO,mul(tW,tVP));
	output.TexCd = TexCd;
	return output;
}

float4 PS(vs2ps In) : SV_Target
{
   float2 pos = 256.0*In.TexCd.xy + time;
	pos.x *=  R.x / R.y;

    float3 col = float(0.0);
    for( int i=0; i<6; i++ ) 
    {
        float2 a = floor(pos);
        float2 b = frac(pos);
        
        float4 w = frac((sin(a.x*7.0+31.0*a.y + 0.01*time)+float4(0.035,0.01,0.0,0.7))*13.545317); // randoms
                
        col += w.xyz *                                   // color
               smoothstep(0.45,0.55,w.w) *               // intensity
               sqrt( 16.0*b.x*b.y*(1.0-b.x)*(1.0-b.y) ); // pattern
        
        pos /= 2.0; // lacunarity
        col /= 2.0; // attenuate high frequencies
    }
    
    col = pow( 2.5*col, float3(1.0,1.0,0.7) );    // contrast and color shape
    
    return float4( col, 1.0 );
}


technique10 FractalTiling
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



