// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float2 R:TARGETSIZE;

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;	
float4x4 tW:WORLD;
float time;
};

struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{

    float2 uv = In.TexCd.xy;
	uv.y=1-In.TexCd.y;
    // shape (16 points)	
	float t = time + 47.0;
	float2 z = -1.0 + 2.0*uv;
	float3 col = float(1.0);
	for( int j=0; j<16; j++ )
	{
        // deform		
        float s = float(j)/16.0;
		float f = 0.2*(0.5 + 1.0*frac(sin(s*113.1)*43758.5453123));
		float2 c = 0.5*float2( cos(f*t+17.0*s),sin(f*t+19.0*s) );
		z -= c;
		float zr = length( z );
	    float ar = atan2( z.y, z.x ) + zr*0.6;
	    z  = float2( cos(ar), sin(ar) )/zr;
		z += c;
        z += 0.05*sin(2.0*z.x);

        // color		
        col -= 0.7*exp( -8.0*dot(z,z) )* (0.5+0.5*sin( 4.2*s + float3(1.6,0.9,0.3) ));
	}
    col *= 0.75 + 0.25*clamp(length(z-uv)*0.6,0.0,1.0);

	// 3d effect
	float h = dot(col,float(0.333));
	float3 nor = normalize( float3( ddx(h), ddy(h), 1.0/R.x ) );
	col -= 0.05*float3(1.0,0.9,0.5)*dot(nor,float3(0.8,0.4,0.2));;
	col += 0.25*(1.0-0.8*col)*nor.z*nor.z;

    // 2d postpro	
	col *= 1.12;
    col = pow( clamp(col,0.0,1.0), float(0.8) );
	col *= 0.8 + 0.2*pow( abs(16.0*uv.x*uv.y*(1.0-uv.x))*abs((1.0-uv.y)), 0.1 );
	return float4( col, 1.0 );
}


technique10 IterationsInversion
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



