/// Created by inigo quilez - iq/2014
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.						    

// The sixth member of the "Iterations" collection:
//
// Inversion:     https://www.shadertoy.com/view/XdXGDS
// Worms:         https://www.shadertoy.com/view/ldl3W4
// Coral:         https://www.shadertoy.com/view/4sXGDN
// Guts:          https://www.shadertoy.com/view/MssGW4
// Trigonometric: https://www.shadertoy.com/view/Mdl3RH


float2 R:TARGETSIZE;

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;	
float4x4 tW:WORLD;
float time;
};

float3 shape( in float2 p )
{
	p *= 2.0;
	
	float3 s = float( 0.0 );
	float2 z = p;
	for( int i=0; i<8; i++ ) 
	{
        // transform		
		z += cos(z.yx + cos(z.yx + cos(z.yx+0.5*time) ) );

        // orbit traps		
		float d = dot( z-p, z-p ); 
		s.x += 1.0/(1.0+d);
		s.y += d;
		s.z += sin(atan2(z.y-p.y,z.x-p.x));
		
	}
	
	return s / 8.0;
}

struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float2 pc = 1.5*In.TexCd.xy/.5;

	float2 pa = pc + float2(0.04,0.0);
	float2 pb = pc + float2(0.0,0.04);
	
    // shape (3 times for diferentials)	
	float3 sc = shape( pc );
	float3 sa = shape( pa );
	float3 sb = shape( pb );

    // color	
	float3 col = lerp( float3(0.08,0.02,0.15), float3(0.6,1.1,1.6), sc.x );
	col = lerp( col, col.zxy, smoothstep(-0.5,0.5,cos(0.5*time)) );
	col *= 0.15*sc.y;
	col += 0.4*abs(sc.z) - 0.1;

    // light	
	float3 nor = normalize( float3( sa.x-sc.x, 0.01, sb.x-sc.x ) );
	float dif = clamp(0.5 + 0.5*dot( nor,float(0.5773) ),0.0,1.0);
	col *= 1.0 + 0.7*dif*col;
	col += 0.3 * pow(nor.y,128.0);

    // vignetting	
	col *= 1.0 - 0.1*length(pc);
	
	return float4( col, 1.0 );
}

technique10 IterationsShiny
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



