// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float2 R:TARGETSIZE;

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;	
float4x4 tW:WORLD;
float time;
float iteratemore;	
};

float2 iterate( in float2 p, in float4 t )
{
    return p - 0.05*cos(t.xz + p.x*p.y + cos(t.yw+1.5*3.1415927*p.yx)+p.yx*p.yx );
}

struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float2 q = In.TexCd.xy;
	q.y=1-In.TexCd.y;
	float2 p = -1.0 + 2.0*q;
	p.x *= R.x/R.y;
    p *= 1.5;	

    float4 t = 0.15*time*float4( 1.0, -1.5, 1.2, -1.6 ) + float4(0.0,2.0,3.0,1.0);
	
    float2 z = p;
	float3 s = float(0.0);
	for( int i=0; i<100; i++ ) 
	{
		z = iterate( z, t );

		float d = dot( z-p, z-p ); 
		s.x += 1.0/(0.1+d);
		s.y += sin(atan2( p.x-z.x, p.y-z.y ));
		s.z += exp(-0.2*d );
	}
    s /= 100.0;
	
	float3 col = 0.5 + 0.5*cos( float3(0.0,0.4,0.8) + 2.5 + s.z*6.2831 );
	
	col *= 0.5 + 0.5*s.y;
    col *= s.x;
    col *= 0.94+0.06*sin(10.0*length(z));
	
	float3 nor = normalize( float3( ddx(s.x), 0.02, ddy(s.x) ) );
	float dif = dot( nor, float3(0.7,0.1,0.7) );
	col -= 0.05*float(dif);

	col *= 0.3 + 0.7*pow( abs(16.0*q.x*q.y*(1.0-q.x))*abs((1.0-q.y)), 0.2 );
	
	return float4( col, 1.0 );
}

technique10 IterationsTrigonometric
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	}
}



