
float2 R:TARGETSIZE;

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
float RADIUS = 0.25;
};


float rand(float3 n) 
{
  n = floor(n);
  return frac(sin((n.x+n.y*1e2+n.z*1e4)*1e-4)*1e5);
}

// .x is distance, .y = colour
float2 map( float3 p ) 
{
	// cylinder
	float3 f = frac( p ) - 0.5;
	float d = length( f.xy );
    float cr = rand( p );
	float cd = d - cr*RADIUS;

	// end - calc (rand) radius at more stable pos
	p.z -= 0.5;
	float rr = rand( p );
	float rn = d - rr*RADIUS;
    float rm = abs( frac( p.z ) - 0.5 );  // offset so at end of cylinder
       
	float rd = sqrt( rn*rn + rm*rm ); // end with ring

	return (cd < rd) ?  float2( cd, cr ) : float2( rd, rr ); // min
}


struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
   // Setup:
	float2 pos = 1-2*(In.TexCd.xy );
	pos.x *=  R.x / R.y;
    float3 camPos = float3(cos(time*0.3), sin(time*0.3), 3.5);
    float3 camTarget = float3(0.0, 0.0, .0);

    float3 camDir = normalize(camTarget-camPos);
    float3 camUp  = normalize(float3(0.0, 1.0, 0.0));
    float3 camSide = cross(camDir, camUp);
    float focus = 1.8;

    float3 rayDir = normalize(camSide*pos.x + camUp*pos.y + camDir*focus);
    float3 ray = camPos;
    float m = 0.32;
    float2 d;
    float total_d = 0.;
    const int MAX_MARCH = 100;
    const float MAX_DISTANCE = 100.0;
    for(int i=0; i<MAX_MARCH; ++i) {
        d = map(ray-float3(0.,0.,time/2.));
        total_d += d.x;
        ray += rayDir * d.x;
        m += 1.0;
        if(abs(d.x)<0.01) { break; }
        if(total_d>MAX_DISTANCE) { total_d=MAX_DISTANCE; break; }
    }

    float c = (total_d)*0.0001;
    float4 result = float4( 1.0-float3(c, c, c) - float3(0.025, 0.025, 0.02)*m*0.8, 1.0 );
    return result*d.y;
}


technique10 Nanotubes
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



