// Created by genis sole - 2015
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

// Enable more representative frequency analysis.
//#define CF 

float2 R:TARGETSIZE;
Texture2D tex0 <string uiname="Texture";>;
SamplerState s0 <string uiname="Sampler State";>
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float4 Col1 <bool color=true;> ={0.5,0.5,0.5,1.0};
float4 Col2 <bool color=true;> ={0.5,0.5,0.5,1.0};
float4 Col3 <bool color=true;> ={1.0,1.0,0.5,1.0};
float4 Col4 <bool color=true;> ={0.4,0.3,0.5,1.0};
float time;
float distance=5;
float4 freqs = float4(0.6, 0.7, 0.2, 0.2);	
};

float4 FreqAnalysis() 
{
	return freqs;
	
float4 sy = float(0.0);    
    
#ifdef CF
    // 0.25 / (512 / 4) = 0.001953125
    for(float i = 0.0; i < 0.25; i += 0.001953125) 
	{
   		sy.x += tex0.Sample(s0, float2(i, 0.0)).x;
    }
    
    for(float i = 0.25; i < 0.5; i += 0.001953125) 
	{
   		sy.y += tex0.Sample(s0, float2(i, 0.0)).x;
    }
    
    for(float i = 0.5; i < 0.75; i += 0.001953125) 
	{
   		sy.z += tex0.Sample(s0, float2(i, 0.0)).x;
    }
    
    for(float i = 0.75; i <= 1.0; i += 0.001953125) 
	{
   		sy.w += tex0.Sample(s0, float2(i, 0.0)).x;
    }
    sy *= float4(0.0078125); // 1 / (512 / 4) = 0.0078125
    
#else
    
    sy.x = tex0.Sample(s0, float2(0.0, 0.0)).x;
	sy.y = tex0.Sample(s0, float2(0.33, 0.0)).x;
    sy.z = tex0.Sample(s0, float2(0.66, 0.0)).x;
    sy.w = tex0.Sample(s0, float2(1.0, 0.0)).x;
    
#endif
    
    return sy;
    //return step(0.01, iChannelTime[0])*sy + (1.0 - step(0.01, iChannelTime[0]))*freqs;
}


float3 rgb2hsv(float3 c) 
{
    float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    float4 p = lerp(float4(c.bg, K.wz), float4(c.gb, K.xy), step(c.b, c.g));
    float4 q = lerp(float4(p.xyw, c.r), float4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return float3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

float3 hsv2rgb(float3 c) 
{
    float4 K = float4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    float3 p = abs(frac(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * lerp(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

float sin3(in float3 p) 
{
	return (sin(p.x) + sin(p.y) + sin(p.z));
}

float noise(in float3 p)
{
    float j = time * 0.045;
    float v = (sin3((p+float3(j*7.0, j*2.3, j*1.0)) * 10.0) * freqs.w +
               sin3((p+float3(j*3.0, j*1.2, j*0.4)) * 8.0) * freqs.z +
               sin3((p+float3(j*2.4, j*0.6, j*2.6)) * 6.0) * freqs.y +
               sin3((p+float3(j*1.4, j*5.8, j*1.9)) * 4.0) * freqs.x) * 0.25;
    //return 0.0;
    
    v = abs(v);
    float f = floor(v*10.0);
    
    v = clamp((smoothstep(0.0, 1.0, lerp(0.1, 0.2, v*10.0-f)) + f)* 0.1, 0.0, 1.0);
    return v;
}

// Taken from http://iquilezles.org/www/articles/palettes/palettes.htm
float3 ColorPalette(in float t, in float3 a, in float3 b, in float3 c, in float3 d )
{
    return a + b*cos( 6.28318*(c*t+d) );
}


bool RaySphereIntersection(in float3 ro, in float3 rd, in float3 c, in float r, out float3 p0, out float3 p1) 
{
    p0 = float(0.0);
    p1 = float(0.0);
    
   	float3 oc = ro - c;
    float poc = dot(rd, oc);
    
    float sloc = dot(oc, oc);
    float test = poc*poc - sloc + r*r;
        
    if (test < 0.0) return false;
    
    float sqt = sqrt(test);
    float d0 = -poc - sqt;
    float d1 = -poc + sqt;
    
	p0 = ro + d0*rd;
    p1 = ro + d1*rd;
    return true;
}

float3 SphereNormal(in float3 d, in float r, in float e) 
{
    float theta = atan2(d.y,d.x) ;
    float phy = acos(d.z);
    
    float3 dy0 = float3(cos(theta+e)*sin(phy), sin(theta+e)*sin(phy), cos(phy));
    float3 dy1 = float3(cos(theta-e)*sin(phy), sin(theta-e)*sin(phy), cos(phy));

    float3 dx0 = float3(cos(theta)*sin(phy+e), sin(theta)*sin(phy+e), cos(phy+e));
    float3 dx1 = float3(cos(theta)*sin(phy-e), sin(theta)*sin(phy-e), cos(phy-e));
    
    float ny0 = noise(dy0*r);
    float ny1 = noise(dy1*r);
    float nx0 = noise(dx0*r);
    float nx1 = noise(dx1*r);
    
    dy0 *= r + ny0;
    dy1 *= r + ny1;
    dx0 *= r + nx0;
    dx1 *= r + nx1;
    
    return normalize(cross(dy0 - dy1, dx1 - dx0));
}

bool RayMarchPerturbedSphere(in float3 ro, in float3 rd, in float3 c, in float r, in float br, 
                             out float3 n, out float3 sd) {
    n = float(0.0);
    sd = float(0.0);
    
    float3 bp0 = float(0.0);
    float3 bp1 = float(0.0);
    bool bres = RaySphereIntersection(ro, rd, c, br, bp0, bp1);
    if (!bres) return false;
    
    float3 p0 = float(0.0); 
    float3 p1 = float(0.0);
    bool res = RaySphereIntersection(ro, rd, c, r, p0, p1); 
    
    float dist = float(res)*length(p0 - bp0) + (1.0-float(res)) * length(bp0 - bp1);
	//float dist = length(bp0 - bp1);
    const float sc = 128.0;
    const float invsc = 1.0 / sc;
    float s = dist * invsc;
    
    bool ret = false;
    float3 pn = float(0.0);
    for (float d = 0.0; d < sc; ++d) {
    	pn = (bp0 + d*s*rd) - c;
		
        sd = normalize(pn) * r;
        float h = length(pn) - r - s;
        
        float h0 = noise(sd);
        if (h0 > h) {
            ret = true;
            break;
        } 
    }
    
    n = SphereNormal(normalize(pn), r, s);
    return ret;
}


// Based on this: http://iquilezles.org/www/articles/rmshadows/rmshadows.htm        
float ShadowFactor(in float3 sd, in float3 ld, in float3 c, in float r, in float br) 
{
    float w = noise(sd);
    float3 ro = c + (normalize(sd) * (w+r));
    
    float3 bp0 = float(0.0);
    float3 bp1 = float(0.0);
    bool bres = RaySphereIntersection(ro, -ld, c, br, bp0, bp1);
    
    float3 p0 = float(0.0);
    float3 p1 = float(0.0);
    bool res = RaySphereIntersection(ro, -ld, c, r, p0, p1);
    
    float dist = min(length(ro - bp0)+ float(!bres) * 10000.0, 
                     length(ro - p0) + float(!res) * 10000.0);
    
    const float sc = 128.0;
    const float invsc = 1.0 / sc;
    float s = dist * invsc;
    
    float dmin = 1.0;
    
    for (float d = 0.0; d < sc; ++d) {
    	float3 pn = (ro + d*s*-ld) - c;
		
        sd = normalize(pn) * r;
        float h = length(pn) - r + s;
        
        float h0 = noise(sd);
        if (h0 > h) {
            dmin = 0.0;
            break;
        }
        
        dmin = min(dmin, 4.0*(h-h0)/(d*s));
    }
    
    return clamp(dmin, 0.0, 1.0);
    
}


float3 GetColor(float3 sd)
{
    float n = noise(sd);
    float3 c = ColorPalette(n, Col1, Col2,
                               Col3, Col4);
    
    c = rgb2hsv(c);
    c.y += 0.30;
    c.z += 0.1;
    c = hsv2rgb(c);
    
    return c;
    
}

float3 CameraRay(float2 fragCoord, float n) 
{
    //float a = 1.0/max(R.x, R.y);
    
    return normalize(float3((fragCoord - 0.5), n));
}


struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float3 rd = CameraRay(In.TexCd, 1.0);
    float3 sc = float3(0.0, 0.0, distance);
    float sr = 1.0;
 
    float3 n = float(0.0);
    float3 sd = float(0.0);
    if (RaySphereIntersection(float(0.0), rd, sc, sr+1.0, n, sd)) 
	{
       float4 freqs = FreqAnalysis();
    }
    
    bool hit = RayMarchPerturbedSphere(float(0.0), rd, sc, sr, sr+1.0, n, sd);
    
    float3 color = float(0.05);
    if (hit) {
        
        float w = max(max(freqs.x,freqs.y) , max(freqs.z, freqs.w));
        float2 nM = float2(sin(time*1.4), cos(time*1.2));
        
        float3 l = normalize(float3(-(nM.x*2.0 -1.0), -(nM.y*2.0 - 1.0), -0.9 + w*3.0));
        
        float sf = ShadowFactor(sd, l, sc, sr, sr+1.0);
        
        color = GetColor(sd);
        float3 diff = color * max(dot(-l, n), 0.0 ) * sf * 0.95;
        float3 amb = color * 0.05;
        
        color = diff;
    	color += amb;
    }
    
    return float4(pow(abs(color), float(0.55)), 1.0);
}

technique10 reactivsphere
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



