float2 R:TARGETSIZE;

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
float2 rotate;
float3 translate;
float4 Col1 <bool color=true;> ={1.0,0.3,0.0,1.0};
float3 size1;
float4 Col2 <bool color=true;> ={0.5,0.3,0.7,1.0};
float3 size2;
float4 Col3 <bool color=true;> ={0.0,0.5,1.0,1.0};
float3 size3;
float4 Col4 <bool color=true;> ={0.0,1.0,0.2,1.0};
float3 size4;
float4 Col5 <bool color=true;> ={0.0,1.0,0.2,1.0};
float3 size5;
};

float3 rotateY(float3 v, float x)
{
    return float3(
        cos(x)*v.x - sin(x)*v.z,
        v.y,
        sin(x)*v.x + cos(x)*v.z
    );
}

float3 rotateX(float3 v, float x)
{
    return float3(
        v.x,
        v.y*cos(x) - v.z*sin(x),
        v.y*sin(x) + v.z*cos(x)
    );
}

float3 rotateZ(float3 v, float x)
{
    return float3(
        v.x*cos(x) - v.y*sin(x),
        v.x*sin(x) + v.y*cos(x),
        v.z
    );
}

float box(float3 p, float3 pos, float3 size)
{
	return max(max(abs(p.x-pos.x)-size.x,abs(p.y-pos.y)-size.y),abs(p.z-pos.z)-size.z);
}


float ribbon1(float3 p)
{
	return box(p,float3(cos(p.z)*.5,sin(p.z+p.x)*.5,.0),float3(size1.x,size1.y,size1.z+time));
}
float ribbon2(float3 p)
{
	return box(p,float3(cos(p.z+1.5+p.x)*.6,sin(p.z+1.)*.3,.0),float3(size2.x,size2.y,size2.z+time));
}
float ribbon3(float3 p)
{
	return box(p,float3(sin(p.z+p.y)*.4,cos(p.z+p.x)*.5,.0),float3(size3.x,size3.y,size3.z+time));
}
float ribbon4(float3 p)
{
	return box(p,float3(sin(p.z+1.5+p.x)*.5,cos(p.z+1.5)*.6,.0),float3(size4.x,size4.y,size4.z+time));
}

float ribbon5(float3 p)
{
	return box(p,float3(sin(p.z+1.5+p.x)*.4,cos(p.z+p.x)*.6,.0),float3(size5.x,size5.y,size5.z+time));
}

float scene(float3 p)
{
	float d = .5-abs(p.y);
	d = min(d, ribbon1(p) );
	d = min(d, ribbon2(p) );
	d = min(d, ribbon3(p) );
	d = min(d, ribbon4(p) );
	d = min(d, ribbon5(p) );
	
	return d;
}

//Raymarch by distance field
float3 Raymarch(float3 org, float3 dir, int step)
{
	float d=0.0;
	float3 p=org;
	
	for(int i=0; i<64; i++)
	{
		d = scene(p);
		p += d * dir;
	}
	
	return p;
}
//get Normal
float3 getN(float3 p)
{
	float3 eps = float3(0.01,0.0,0.0);
	return normalize(float3(
		scene(p+eps.xyy)-scene(p-eps.xyy),
		scene(p+eps.yxy)-scene(p-eps.yxy),
		scene(p+eps.yyx)-scene(p-eps.yyx)
	));
}

//Ambient Occlusion
float AO(float3 p, float3 n)
{
	float dlt = 0.1;
	float oc = 0.0, d = 1.0;
	for(int i = 0; i<6; i++)
	{
		oc += (float(i) * dlt - scene(p + n * float(i) * dlt)) / d;
		d *= 2.0;
	}
	return clamp(1.0 - oc, 0.0, 1.0);
}


struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float4 color = float(0.0);
	float2 v = -1.0 + 2.0 * In. TexCd.xy;
	v.x *= R.x/R.y;
	
	float3 org = translate;
	float3 dir = normalize(float3(v.x,-v.y,2.));
	dir = rotateX(dir,rotate.x);
	dir = rotateY(dir,rotate.y);
	
	float3 p = Raymarch(org,dir,48);
	float3 n = getN(p);
	
    color = float( max( dot(n.xy*-1.,normalize(p.xy-float2(.0,-.1))),.0)*.01 );
	color += Col1 /(ribbon1(p-n*.01)*20.+.75);
	color += Col2 /(ribbon2(p-n*.01)*20.+.75);
	color += Col3 /(ribbon3(p-n*.01)*20.+.75);
	color += Col4 /(ribbon4(p-n*.01)*20.+.75);
	color += Col5 /(ribbon5(p-n*.01)*20.+.75);
	color *= AO(p,n);
	color = lerp(color,float(0.),float((min(distance(org,p)*.05,1.0))));
	
	return color;
}

technique10 Ribbons
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	}
}



