// Created by inigo quilez - iq/2015
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float2 R:TARGETSIZE;
Texture2D tex0 <string uiname="Texture";>;
SamplerState s0 <string uiname="Sampler State";>
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = wrap;
    AddressV = wrap;
};

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;	
};

float4 texCube( sampler2D sam, in float3 p, in float3 n, in float k )
{
	float4 x = tex0.Sample( s0, p.yz );
	float4 y = tex0.Sample( s0, p.zx );
	float4 z = tex0.Sample( s0, p.xy );
    float3 w = pow( abs(n), float(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

float4 map( float3 p )
{
    p.x += 0.5*sin( 3.0*p.y + time*0.4 );
    p.y += 0.5*sin( 3.0*p.z + time*0.4 );
    p.z += 0.5*sin( 3.0*p.x + time*0.4 );
    p.x += 0.5*sin( 3.0*p.y + time*0.3 );
    p.y += 0.5*sin( 3.0*p.z + time*0.3 );
    p.z += 0.5*sin( 3.0*p.x + time*0.3 );
    p.x += 0.5*sin( 3.0*p.y + time*0.2 );
    p.y += 0.5*sin( 3.0*p.z + time*0.2 );
    p.z += 0.5*sin( 3.0*p.x + time*0.2 );
    p.x += 0.5*sin( 3.0*p.y + time*0.1 );
    p.y += 0.5*sin( 3.0*p.z + time*0.1 );
    p.z += 0.5*sin( 3.0*p.x + time*0.1 );
    float d1 = length(p.xz) - 1.0;
    d1 *= 0.01;	

    return float4( d1, p );
}

float4 intersect( in float3 ro, in float3 rd, in float maxd )
{
    float3 res = float(-1.0);
	float precis = 0.0001;
    float t = 1.0;
    for( int i=0; i<2048; i++ )
    {
	    float4 tmp = map( ro+rd*t );
        res = tmp.yzw;
        float h = tmp.x;
        if( h<precis||t>maxd ) break;
        t += h;
    }

    return float4( t, res );
}

float3 calcNormal( in float3 pos )
{
    float2 e = float2(1.0,-1.0)*0.001;
    return normalize( e.xyy*map( pos + e.xyy ).x + 
					  e.yyx*map( pos + e.yyx ).x + 
					  e.yxy*map( pos + e.yxy ).x + 
					  e.xxx*map( pos + e.xxx ).x );
}

float calcOcc( in float3 pos, in float3 nor )
{
    const float h = 0.2;
	float ao = 0.0;
    for( int i=0; i<8; i++ )
    {
        float3 dir = sin( float(i)*float3(1.0,7.13,13.71)+float3(0.0,2.0,4.0) );
        dir *= sign(dot(dir,nor));
        float d = map( pos + h*dir ).x;
        ao += max(0.0,h-d*2.0);
    }
    return clamp( 4.0 - 2.5*ao, 0.0, 1.0 );
}


struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float2 q = In.TexCd.xy;
	q.y=1-In.TexCd.y;
    float2 p = -1.0 + 2.0 * q;
   	p.x *= R.x/R.y;
    float2 m = float(0.5);
	//if( iMouse.z>0.0 ) m = iMouse.xy/R.xy;

    //-----------------------------------------------------
	
	float an = 0.1*time - 5.0*m.x;
	float3 ro = float3(4.5*sin(an),0.0,4.5*cos(an));
    float3 ta = float3(0.0,0.0,0.0);
    float3 ww = normalize( ta - ro );
    float3 uu = normalize( cross(ww,float3(0.0,1.0,0.0) ) );
    float3 vv = normalize( cross(uu,ww));
	float3 rd = normalize( p.x*uu + p.y*vv + 2.0*ww );

    //-----------------------------------------------------

	float3 col = float(0.1);

    const float maxd = 8.0;
    float4  inn = intersect(ro,rd,maxd);
    float t = inn.x;
    if( t<maxd )
    {
        float3 tra = inn.yzw;

        float3 pos = ro + t*rd;
        float3 nor = calcNormal(pos);

        col = 0.5 + 0.5*sin(tra.y*1.0 + float3(0.0,1.0,2.0) );
        float3 pat = texCube( s0, 0.3*tra, nor, 4.0 ).xyz;
        col *= pat;

        
		float occ = calcOcc( pos, nor );
        float fre = pow( clamp( 1.0 + dot(nor,rd), 0.0, 1.0 ), 4.0 );
        float spe = 0.3*pat.x*max( 0.0, pow( clamp( dot(-rd,nor), 0.0, 1.0), 32.0 ) )*occ;
        
		float3 lin = float(0.0);
        lin += float3(0.8,0.9,1.0)*occ;
        lin += 4.0*fre*float3(1.00,0.80,0.70)*occ;
        lin *= 1.0 + nor.y;
        col = col*lin + spe;

        col = 1.1*pow( abs(col), float3(0.16,0.31,0.4) );
	}

    col *= 0.5 + 0.5*pow( abs(16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y)), 0.2 );
	   
    return float4( col, 1.0 );


}

technique10 SineDeformations
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



