
float2 R:TARGETSIZE;

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
float3 NoiseStrength <float uimin=0.0; float uimax=0.85;> = .25;
float depth;
float3 lDir;
float2 rotation;
float4 Col <bool color=true;> ={0.58,1.0,1.0,1.0};
};

//-----------------------------------------------------------------------------
// Maths utils
//-----------------------------------------------------------------------------
float3x3 m = float3x3( 0.00,  0.80,  0.60,
                      -0.80,  0.36, -0.48,
                      -0.60, -0.48,  0.64 );
float hash( float n )
{
    return frac(sin(n)*43758.5453);
}

float noise( in float3 x )
{
    float3 p = floor(x);
    float3 f = frac(x);

    f = f*f*(3.0-2.0*f);

    float n = p.x + p.y*57.0 + 113.0*p.z;

    float res = lerp(lerp(lerp( hash(n+  0.0), hash(n+  1.0),f.x),
                          lerp( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y),
                     lerp(lerp( hash(n+113.0), hash(n+114.0),f.x),
                          lerp( hash(n+170.0), hash(n+171.0),f.x),f.y),f.z);
    return res;
}

float fbm( float3 p )
{
    float f;
    f  = 0.5000*noise( p ); 
	p = mul(m,p*2.02);
    f += 0.2500*noise( p ); 
	p = mul(m,p*2.03);
    f += 0.1250*noise( p );
    return f;
}

//-----------------------------------------------------------------------------
// Main functions
//-----------------------------------------------------------------------------
float scene(float3 p)
{	
	return .1-length(p)*.05+fbm(time+p*float3(NoiseStrength))+depth;
}

struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW); 
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float2 q = In.TexCd.xy;
    float2 v = -1.0 + 2.0*q;
    v.x *= R.x/ R.y;
	
	float2 mo = rotation;

    // camera by iq
    float3 org = 25.0*normalize(float3(cos(2.75-3.0*mo.x), 0.7-1.0*(mo.y-1.0), sin(2.75-3.0*mo.x)));
	float3 ta = float3(0.0, 1.0, 0.0);
    float3 ww = normalize( ta - org);
    float3 uu = normalize(cross( float3(0.0,1.0,0.0), ww ));
    float3 vv = normalize(cross(ww,uu));
    float3 dir = normalize( v.x*uu + v.y*vv + 1.5*ww );
	float4 color=float(.0);
	
	const int nbSample = 64;
	const int nbSampleLight = 6;
	
	float zMax         = 40.;
	float step         = zMax/float(nbSample);
	float zMaxl        = 20.;
	float stepl        = zMaxl/float(nbSampleLight);
    float3 p           = org;
    float T            = 1.;
    float absorption   = 100.;
	float3 sun_direction = normalize( lDir );
    
	for(int i=0; i<nbSample; i++)
	{
		float density = scene(p);
		if(density>0.)
		{
			float tmp = density / float(nbSample);
			T *= 1. -tmp * absorption;
			if( T <= 0.01)
				break;
				
				
			 //Light scattering
			float Tl = 1.0;
			for(int j=0; j<nbSampleLight; j++)
			{
				float densityLight = scene( p + normalize(sun_direction)*float(j)*stepl);
				if(densityLight>0.)
                	Tl *= 1. - densityLight * absorption/float(nbSample);
                if (Tl <= 0.01)
                    break;
			}
			
			//Add ambiant + light scattering color
			color += float(1.)*50.*tmp*T + Col*80.*tmp*T*Tl;
		}
		p += dir*step;
	}    

    return color;
}

technique10 VolumeRaycasting
{
	pass P0
	{
		SetVertexShader( CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



