//@author: sebl
//@help: 2D voronoi
//@tags: shadertoy
//@credits: inigo quilez - iq/2013
//@license: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.


SamplerState linearSampler : IMMUTABLE
{
	Filter = MIN_MAG_MIP_LINEAR;
	AddressU = Clamp;
	AddressV = Clamp;
};

cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;
	float time;
	
	float size <String uiname="Scale"; float uimin=0.001; float uimax=1.0;> = 0.1;
	
	float4 color <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };
	
	float inside <String uiname="Isolines Count"; float uimin=1.0; float uimax=256.0;> = 32.0;
	float insidefade <String uiname="Isolines Fade"; float uimin=0.0; float uimax=1.0;> = 0.5;

	float linewidth <String uiname="Border Width"; float uimin=0.0; float uimax=1.0;> = 0.04;
	float linefade <String uiname="Border Fade"; float uimin=0.0; float uimax=1.0;> = 0.02;
	
	float pointsize <String uiname="Point Size"; float uimin=0.0; float uimax=1.0;> = 0.5;
	float pointfade <String uiname="Point Fade"; float uimin=0.0; float uimax=1.0;> = 0.5;
	
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
};

struct VS_IN
{
	float4 PosO : POSITION;
	float4 TexCd : TEXCOORD0;
	
};

struct vs2ps
{
	float4 PosWVP: SV_POSITION;
	float4 TexCd: TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
	vs2ps output;
	output.PosWVP  = mul(input.PosO,mul(tW,tVP));
	output.TexCd = input.TexCd;
	return output;
}

//#define ANIMATE

float2 hash2( float2 p )
{
	// texture based white noise
	//return texture2D( iChannel0, (p+0.5)/256.0, -100.0 ).xy;
	
	// procedural white noise
	return frac(sin(float2(dot(p,float2(127.1,311.7)),dot(p,float2(269.5,183.3))))*43758.5453);
}

float3 voronoi( in float2 x )
{
	float2 n = floor(x);
	float2 f = frac(x);
	
	//----------------------------------
	// first pass: regular voronoi
	//----------------------------------
	float2 mg, mr;
	
	float md = 8.0;
	for( int j=-1; j<=1; j++ )
	for( int i=-1; i<=1; i++ )
	{
		float2 g = float2(float(i),float(j));
		float2 o = hash2( n + g );
		
		o = 0.5 + 0.5*sin( time + 6.2831*o );
		
		float2 r = g + o - f;
		float d = dot(r,r);
		
		if( d<md )
		{
			md = d;
			mr = r;
			mg = g;
		}
	}
	
	//----------------------------------
	// second pass: distance to borders
	//----------------------------------
	md = 8.0;
	for( int k = -2; k <= 2; k++ )
	{
		for( int i = -2; i <= 2; i++ )
		{
			float2 g = mg + float2(float(i),float(k));
			float2 o = hash2( n + g );

			o = 0.5 + 0.5*sin( time + 6.2831*o );

			float2 r = g + o - f;
			
			if( dot(mr-r,mr-r)>0.00001 )
			md = min( md, dot( 0.5*(mr+r), normalize(r-mr) ) );
		}
	}
	return float3( md, mr );
}

///////////////////////////// PS ///////////////////////////////////////////////

float4 PSVoronoiBorders(vs2ps In): SV_Target
{
	float2 p = In.TexCd.rg;
	float3 c = voronoi( p / size );
	float3 col = float3(0.0, 0.0, 0.0);;
	
	col = lerp( color.rgb, col, smoothstep( linewidth, linewidth+linefade, c.x ) ) ;
	
	return  float4(col,1.0);
	
	
}

float4 PSVoronoiInside(vs2ps In): SV_Target
{
	float2 p = In.TexCd.rg;
	float3 c = voronoi( p / size );
	float3 col = float3(0.0, 0.0, 0.0);;
	
	col = c.x * ( (insidefade*32) * sin(inside*c.x)) * color.rgb;
	
	return  float4(col,1.0);
	
	
}

float4 PSVoronoiPoints(vs2ps In): SV_Target
{
	float2 p = In.TexCd.rg;
	float3 c = voronoi( p / size);
	float3 col = float3(0.0, 0.0, 0.0);;
	
	float dd = length( c.yz );

	col = lerp( color.rgb, col, smoothstep( pointsize, pointsize+pointfade, dd) );
	
	return  float4(col,1.0);
}

///////////////////////////// TECHINQUES ///////////////////////////////////////


technique10 Voronoi_Borders
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PSVoronoiBorders() ) );
	}
}

technique10 Voronoi_Inside
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PSVoronoiInside() ) );
	}
}

technique10 Voronoi_Points
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PSVoronoiPoints() ) );
	}
}






