// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

//===============================================================================================
//===============================================================================================
//===============================================================================================


float2 R:TARGETSIZE;

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
};

// do not use texture
#define FULL_PROCEDURAL

#ifdef FULL_PROCEDURAL
float3 hash( float3 x )
{
	x = float3( dot(x,float3(127.1,311.7, 74.7)),
			    dot(x,float3(269.5,183.3,246.1)),
			    dot(x,float3(113.5,271.9,124.6)));

	return frac(sin(x)*43758.5453123);
}
#else
float3 hash( float3 x )
{
	return texture2D( iChannel0, (x.xy+vec2(3.0,1.0)*x.z+0.5)/256.0, -100.0 ).xyz;
}
#endif

// returns closest, second closest, and cell id
float3 voronoi( in float3 x )
{
    float3 p = floor( x );
    float3 f = frac( x );

	float id = 0.0;
    float2 res = float( 100.0 );
    for( int k=-1; k<=1; k++ )
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    {
        float3 b = float3( float(i), float(j), float(k) );
        float3 r = float3( b ) - f + hash( p + b );
        float d = dot( r, r );

        if( d < res.x )
        {
			id = dot( p+b, float3(1.0,57.0,113.0 ) );
            res = float2( d, res.x );			
        }
        else if( d < res.y )
        {
            res.y = d;
        }
    }

    return float3( sqrt( res ), abs(id) );
}
//===============================================================================================
//===============================================================================================
//===============================================================================================
//===============================================================================================
//===============================================================================================

float3x3 m = float3x3( 0.00,  0.80,  0.60,
                   	  -0.80,  0.36, -0.48,
                      -0.60, -0.48,  0.64 );


struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
	float2 uv=(In.TexCd).xy;
    uv.y=1-In.TexCd.y;
	float2 p = 2*(uv.xy-0.5);
	p.x *=  R.x / R.y;
     
     // camera movement	
	float an = 0.5*time;
	float3 ro = float3( 2.5*cos(an), 1.0, 2.5*sin(an) );
    float3 ta = float3( 0.0, 1.0, 0.0 );
    // camera matrix
    float3 ww = normalize( ta - ro );
    float3 uu = normalize( cross(ww,float3(0.0,1.0,0.0) ) );
    float3 vv = normalize( cross(uu,ww));
	// create view ray
	float3 rd = normalize( p.x*uu + p.y*vv + 1.5*ww );

    // sphere center	
	float3 sc = float3(0.0,1.0,0.0);

    // raytrace
	float tmin = 10000.0;
	float3  nor = float(0.0);
	float occ = 1.0;
	float3  pos = float(0.0);
	
	// raytrace-plane
	float h = (0.0-ro.y)/rd.y;
	if( h>0.0 ) 
	{ 
		tmin = h; 
		nor = float3(0.0,1.0,0.0); 
		pos = ro + h*rd;
		float3 di = sc - pos;
		float l = length(di);
		occ = 1.0 - dot(nor,di/l)*1.0*1.0/(l*l); 
	}

	// raytrace-sphere
	float3  ce = ro - sc;
	float b = dot( rd, ce );
	float c = dot( ce, ce ) - 1.0;
	h = b*b - c;
	if( h>0.0 )
	{
		h = -b - sqrt(h);
		if( h<tmin ) 
		{ 
			tmin=h; 
			nor = normalize(ro+h*rd-sc); 
			occ = 0.5 + 0.5*nor.y;
		}
	}

    // shading/lighting	
	float3 col = float(0.9);
	if( tmin<100.0 )
	{
	    pos = ro + tmin*rd;
		
		float f = voronoi( 4.0*pos ).x;
		
		f *= occ;
		col = float(f*1.2);
		col = lerp( col, float(0.9), 1.0-exp( -0.003*tmin*tmin ) );
	}
	
	col = sqrt( col );
	
	
	return float4( col, 1.0 );

}


technique10 Voronoi3D
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



