// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float2 R:TARGETSIZE;

Texture2D tex0 <string uiname="NoiseTexture";>;
Texture2D tex1 <string uiname="Texture";>;
SamplerState s0  <bool visible=false;string uiname="Sampler";> 
{
	Filter=MIN_MAG_MIP_LINEAR;
	AddressU=wrap;
	AddressV=wrap;
};

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float Time;	
};

#define FASTNOISE

#ifdef FASTNOISE
float noise( in float3 x )
{
	float3 p = floor(x);
	float3 f = frac(x);
    f = f*f*(3.0-2.0*f);
    float2 uv = (p.xy+float2(37.0,17.0)*p.z) + f.xy;
	float2 rg = tex0.SampleLevel( s0, (uv+0.5)/256.0, -100.0 ).yx;
	return lerp( rg.x, rg.y, f.z );
}
#else
float noise( in float3 x )
{
    float3 p = floor(x);
    float3 f = fract(x);
	f = f*f*(3.0-2.0*f);
    
	float2 uv = p.xy + float2(37.0,17.0)*p.z;

	float2 rgA = tex0.SampleLevel( s0, (uv+0.5+float2(0.0,0.0))/256.0, -100.0 ).yx;
    float2 rgB = tex0.SampleLevel( s0, (uv+0.5+float2(1.0,0.0))/256.0, -100.0 ).yx;
    float2 rgC = tex0.SampleLevel( s0, (uv+0.5+float2(0.0,1.0))/256.0, -100.0 ).yx;
    float2 rgD = tex0.SampleLevel( s0, (uv+0.5+float2(1.0,1.0))/256.0, -100.0 ).yx;

    float2 rg = lerp( lerp( rgA, rgB, f.x ),
                      lerp( rgC, rgD, f.x ), f.y );
    return lerp( rg.x, rg.y, f.z );
}
#endif

float4 texcube( Texture2D tex1, in float3 p, in float3 n )
{
	float4 x = tex1.Sample( s0, p.yz );
	float4 y = tex1.Sample( s0, p.zx );
	float4 z = tex1.Sample( s0, p.xy );
	return x*abs(n.x) + y*abs(n.y) + z*abs(n.z);
}

//=====================================================================
float3x3 m = float3x3( 0.00,  0.80,  0.60,
					  -0.80,  0.36, -0.48,
					  -0.60, -0.48,  0.64 );

float mocc;
float4 mapTerrain( in float3 pos )
{
	float3 q = pos*0.5;
    
    float3  dir = float3(0.0,1.0,0.0);
	float spe = 0.04;
	float time = 5.0 + (Time-10.0)*0.5;
	
	q.xyz += 2.0*noise( 2.0*q )*float3(1.0,3.0,1.0);
	
	float f;
	q *= float3(1.0,2.0,1.0);
	q += dir*time*8.0*spe; f  = 0.50000*noise( q ); q = q*2.02;
	q += dir*time*4.0*spe; f += 0.25000*noise( q ); q = q*2.03;
	q += dir*time*2.0*spe; f += 0.12500*noise( q ); q = q*2.01;
    q += dir*time*1.0*spe; f += 0.06250*noise( q );
    
	float d =  pos.y + 0.9 - 2.0*f;
    float mocc = f;
	return float4(q,d);
}

float4 raymarchTerrain( in float3 ro, in float3 rd )
{
	float maxd = 20.0;
    float precis = 0.0001;
	float h = 1.0;
	float t = 0.1;
	
	float4 res = float(0.0);
	for( int i=0; i<200; i++ )
	{
		if( abs(h)<precis||t>maxd ) break;

		res = mapTerrain( ro+rd*t );
		h = res.w*0.08;
		t += h;
	}
	if( t>maxd ) t=-1.0;
	return float4(res.xyz,t);
}

float3 calcNormal( in float3 pos )
{
	float3 eps = float3(0.015,0.0,0.0);
	
	return normalize( float3(
		mapTerrain(pos+eps.xyy).w - mapTerrain(pos-eps.xyy).w,
		mapTerrain(pos+eps.yxy).w - mapTerrain(pos-eps.yxy).w,
		mapTerrain(pos+eps.yyx).w - mapTerrain(pos-eps.yyx).w ) );

}

float3 lig = normalize( float3(0.0,0.2,0.7) );

float softshadow( in float3 ro, in float3 rd, float mint, float k )
{
	float res = 1.0;
	float t = mint;
	for( int i=0; i<48; i++ )
	{
		float h = mapTerrain(ro + rd*t).w;
		h = max( h*0.08, 0.0 );
		res = min( res, k*h/t );
		t += clamp( h, 0.02, 0.5 );
		if( h<0.0001 ) break;
	}
	return clamp(res,0.0,1.0);
}

float3 path( float time )
{
	return float3( 2.5*cos(0.03*time), 1.5, 2.5*sin(0.03*time) );

}

struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float2 q = In.TexCd.xy ;
	float2 p = -1 + 2.0*q;
	p.x *=  R.x / R.y;
	p.y = 1-In.TexCd.y ;
	
	// camera
	float time = 125.0-Time+10.0;
	float3 ro = path( time+0.0 );
	float3 ta = float3(0.0,-0.5,0.0);
	float roll = 0.15*cos(0.07*time);
	
	// camera tx
	float3 cw = normalize(ta-ro);
	float3 cp = float3(sin(roll), cos(roll),0.0);
	float3 cu = normalize(cross(cw,cp));
	float3 cv = normalize(cross(cu,cw));
	float r2 = p.x*p.x*0.32 + p.y*p.y;
	p *= (7.0-sqrt(37.5-11.5*r2))/(r2+1.0);
	float3 rd = normalize( p.x*cu + p.y*cv + 1.3*cw );
	
	// sky
	float3 col = float3(0.25,0.36,0.36)*1.3 - rd.y*0.5;
	float sun = clamp( dot(rd,lig), 0.0, 1.0 );
	col += float3(1.0,0.8,0.4)*0.2*pow( sun, 6.0 );
	float3 bcol = col;
	
	// terrain
	float4 res = raymarchTerrain(ro, rd);
	float t = res.w;
	if( t>0.0 )
    {
        float occ = pow( clamp(mocc*2.2-0.6,0.0,1.0), 1.5 );
		float3 pos = ro + t*rd;
		float3 nor = calcNormal( pos );
		
		// lighting
		float dif = sqrt(clamp( dot( nor, lig ), 0.0, 1.0 ));
		float sha = 0.0; if( dif>0.01) sha=softshadow(pos,lig,0.01, 40.0);
		float bac = clamp( dot( nor, normalize(lig*float3(-1.0,0.0,-1.0)) ), 0.0, 1.0 );
		float sky = 0.5 + 0.5*nor.y;
		float amb = 1.0;
		
		float3 brdf  = 1.5*dif*float3(1.2,0.70,0.50)*sha*(0.8+0.2*occ);
		     brdf += 0.6*amb*float3(0.4,0.28,0.10)*occ;
             brdf += 0.7*bac*float3(0.7,0.35,0.15)*occ;
             brdf += 0.8*sky*float3(0.2,0.35,0.40)*occ;
		
		// surface shading/material
		col  = texcube( tex1, 0.005*res.xyz, nor ).xyz;
		col *= texcube( tex1, 0.050*res.xyz, nor ).xyz;
		col = sqrt(sqrt(col));
		col *= float3(1.2,1.1,1.0);
		col = lerp( col, col*float3(2.0,0.4,0.4), 0.8*clamp( 1.0-2.0*occ,0.0,1.0) );
		
		// light/surface interaction
		col = brdf * col;
		col = lerp( col, float(dot(col,float(0.33))), 0.5*dif-0.2 );
		
		// atmospheric
		float hh = 1.0 - smoothstep( -2.0, 1.0, pos.y );
		col = lerp( col, (1.0-0.7*hh)*bcol, 1.0-exp(-0.002*t*t*t) );
	}
	
	// sun glow
	col += float3(1.2,0.7,0.2)*0.53*pow( sun, 3.0 )*clamp( (rd.y+0.4)/(0.0+0.4),0.0,1.0);
	
	// gamma
	col = pow( clamp( col, 0.0, 1.0 ), float(0.45) );
	
	// contrast, desat, tint and vignetting
	col = col*col*(3.0-2.0*col);
	col *= 0.5 + 0.5*pow( abs(16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y)), 0.15 );
	
	return float4 ( col, 1.0 );
}

technique10 wavy
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



