// Created by inigo quilez - iq/2014
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.


#define HIGH_QUALITY_NOISE

float2 R:TARGETSIZE;
Texture2D tex0;
SamplerState s0:IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = wrap;
    AddressV = wrap;
};

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float2 rotate;
float time;
};

////////////////////////////////////
float3 hash( float3 x )
{
	return tex0.SampleLevel( s0, (x.xy+float2(3.0,1.0)*x.z+0.5)/256.0, -100.0 ).xyz;
}

float noise( in float3 x )
{
    float3 p = floor(x);
    float3 f = frac(x);
	f = f*f*(3.0-2.0*f);
#ifndef HIGH_QUALITY_NOISE
	float2 uv = (p.xy+float2(37.0,17.0)*p.z) + f.xy;
	float2 rg = tex0.SampleLevel iChannel0, (uv+0.5)/256.0, -100.0 ).yx;
#else
	float2 uv = (p.xy+float2(37.0,17.0)*p.z);
	float2 rg1 = tex0.SampleLevel( s0, (uv+float2(0.5,0.5))/256.0, -100.0 ).yx;
	float2 rg2 = tex0.SampleLevel( s0, (uv+float2(1.5,0.5))/256.0, -100.0 ).yx;
	float2 rg3 = tex0.SampleLevel( s0, (uv+float2(0.5,1.5))/256.0, -100.0 ).yx;
	float2 rg4 = tex0.SampleLevel( s0, (uv+float2(1.5,1.5))/256.0, -100.0 ).yx;
	float2 rg = lerp( lerp(rg1,rg2,f.x), lerp(rg3,rg4,f.x), f.y );
#endif	
	return lerp( rg.x, rg.y, f.z );
}

float2 iSphere( in float3 ro, in float3 rd, in float4 sph )
{
	float3 oc = ro - sph.xyz;
	float b = dot( oc, rd );
	float c = dot( oc, oc ) - sph.w*sph.w;
	float h = b*b - c;
	if( h<0.0 ) 
	return float(-1.0);
	h = sqrt(h);
	return float2(-b-h, -b+h );
}

float2 voronoi( in float3 x, out float3 cen )
{
    float3 p = floor( x );
    float3 f = frac( x );

	float id = 0.0;
    float res = 100.0;
    for( int k=-1; k<=1; k++ )
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    {
        float3 b = float3( float(i), float(j), float(k) );
        float3 r = float3( b ) - f + hash( p + b );
        float d = dot( r, r );

        if( d < res )
        {
			id = dot( p+b, float3(1.0,57.0,113.0 ) );
            res = d;
			cen = p + r + f;
        }
    }

    return float2( sqrt( res ), id );
}

float4 map( in float3 p )
{
	float3 q = 8.0*p;
	float n = 0.0;
	n  = 0.5000*noise( q ); q = q*2.02;
    n += 0.2500*noise( q ); q = q*2.03;
    n += 0.1250*noise( q );
	
	float3 cen = float(0.0);
	float2 vor = voronoi( 2.0*p, cen );
	float f = 1.0-1.5*vor.x; cen /= 2.0;
	f -= smoothstep( 0.4, 0.5, n );
	
    float d = 2.0*f;
	
	d *= smoothstep( 0.0, 0.2, 1.0-length(p) );
	d *= smoothstep( 0.0, 0.2, 1.0-length(cen) );
	d = clamp( d, 0.0, 1.0 );
	
	float3 col = lerp( float3(1.0,0.85,0.7), float3(0.2,0.0,0.0), d );
	
	col -= 0.05*sin( 5.0*vor.y + float3(1.0,2.0,3.0) );
	
	return float4( col, d );
}

float3 sundir = float3(0.0,0.5,-1.0);

float4 raymarch( in float3 ro, in float3 rd, in float2 tminmax )
{
	float4 sum = float4(0, 0, 0, 0);

	float dt = 0.015;
	
	float t = tminmax.x;// + dt*hash(ro).x;
	for(int i=0; i<64; i++)
	{
		if( sum.a > 0.99 || t>tminmax.y ) break;

		float3 pos = ro + t*rd;
		float4 col = map( pos );
		
		float dif = clamp((col.w - map(pos+0.01*sundir).w)/0.01, 0.0, 1.0 );
        float occ = dot(pos,pos);
        float3 lin = float3(0.2,0.2,0.2) + float3(1.0, 0.9, 0.7)*dif;
		col.xyz *= lin*2.5*occ*occ;
		
		col.a *= 0.1;
		col.rgb *= col.a;

		sum = sum + col*(1.0 - sum.a) * dt/0.01;	

		t += dt;
	}

	sum.xyz /= (0.001+sum.w);

	return clamp( sum, 0.0, 1.0 );
}

struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float2 q = In.TexCd.xy ;
    float2 p = -1.0 + 2.0*q;
    p.x *= R.x/ R.y;
    float2 mo = rotate.xy ;
    float2 an = 2.0 + 0.2*time - mo.xy;

	float4 ro = 2.0*float4(cos (an), sin(an));
	float3 ta = float3(0.0, 0.0, 0.0);
    float3 ww = normalize( ta - ro);
    float3 uu = normalize( cross( float3(0.0,1.0,0.0), ww ) );
    float3 vv = normalize( cross(ww,uu) );
    float3 rd = normalize( p.x*uu + p.y*vv + 2.0*ww );

	float3 col = float3(0.05,0.04,0.03);
    float2 seg = iSphere( ro, rd, float4(0.0,0.0,0.0,1.0) );
	if( seg.x>0.0 )
	{
        float4 res = raymarch( ro, rd, seg );
	    col = lerp( col, res.xyz, res.w );
	}
	
	col = lerp( col, float(dot(col,float(0.333))), -0.1 );
	
	col = pow( abs(col), float(0.45) ) * 1.2;

	col *= sqrt( 16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y) );
	    
    return float4( col, 1.0 );

}


technique10 weirdthing
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



