#region usings
using System;
using System.ComponentModel.Composition;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Collections.Specialized;
using System.IO;
using System.IO.Compression;
//using System.Collections.Specialized;
using System.Text.RegularExpressions;
using System.Dynamic;
using System.Collections;
using System.Collections.ObjectModel;
using System.Net.Security;
using System.Web;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "CustomHeaderHTTPPost", Category = "String", Help = "Basic template with one string in/out", Tags = "")]
	#endregion PluginInfo
	public class StringCustomHeaderHTTPPostNode : IPluginEvaluate
	{
		#region fields & pins
		
		[Input("Input222", IsBang = true)]
		ISpread<bool> FInput;
		
		[Input("URL", DefaultString = "ddd")]
		ISpread<string> FInput2;
		
		[Input("BearerToken")]
		ISpread<string> FInput3;

		[Output("Output")]
		ISpread<string> FOutput;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = SpreadMax;

			if(FInput[0] == true)
			{
			
				
				
				
			// Create a request using a URL that can receive a post. 
            WebRequest request = WebRequest.Create (FInput2[0]);
            // Set the Method property of the request to POST.
            //request.Headers.Add("Authorization", FInput3[0]);
			
			request.Method = "POST";
            // Create POST data and convert it to a byte array.
            string postData = "grant_type=client_credentials";
            byte[] byteArray = Encoding.UTF8.GetBytes (postData);
            // Set the ContentType property of the WebRequest.
			request.Headers.Add("Authorization", FInput3[0]);
			
            request.ContentType = "application/x-www-form-urlencoded;charset=UTF-8";
            // Set the ContentLength property of the WebRequest.
            request.ContentLength = byteArray.Length;
            // Get the request stream.
				
			//request.Headers.Add("Authorization", FInput3[0]);
				
				
			FLogger.Log(LogType.Debug,"\nThe HttpHeaders are \n\n\tName\t\tValue\n{0}",request.Headers);
				
				
				
				
				
            Stream dataStream = request.GetRequestStream ();
            // Write the data to the request stream.
            dataStream.Write (byteArray, 0, byteArray.Length);
            // Close the Stream object.
            dataStream.Close ();
            // Get the response.
            WebResponse response = request.GetResponse ();
            // Display the status.
            Console.WriteLine (((HttpWebResponse)response).StatusDescription);
            // Get the stream containing content returned by the server.
            dataStream = response.GetResponseStream ();
            // Open the stream using a StreamReader for easy access.
            StreamReader reader = new StreamReader (dataStream);
            // Read the content.
            string responseFromServer = reader.ReadToEnd ();
            // Display the content.
            FOutput[0] = responseFromServer;
            // Clean up the streams.
            reader.Close ();
            dataStream.Close ();
            response.Close ();
				
				
			}
		}
	}
}
