#region usings
using System;
using System.ComponentModel.Composition;
using System.Web;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{	
	
	public enum HttpUtillityMethods
	{
		HtmlEncode,
		HtmlDecode,
		UrlEncode,
		UrlEncodeUnicode,
		UrlDecode
	}
	
	
 #region PluginInfo
	[PluginInfo(Author= "bjo:rn", Name = "HTTPUtility", Category = "String", Help = "Implements some of the C# HttpUtility methods", Tags = "", Credits = "http://msdn.microsoft.com/en-us/library/90d18ktz.aspx")]
	#endregion PluginInfo
	public class StringHTTPUtilityNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultString = "hello wörld")]
		IDiffSpread<string> FInput;
		
		[Input("Method", DefaultEnumEntry = "UrlEncode")]
		IDiffSpread<HttpUtillityMethods> FMethod;

		[Output("Output")]
		ISpread<string> FOutput;

		
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = SpreadMax;


			if (FInput.IsChanged || FMethod.IsChanged)
			{
				for (int i = 0; i < SpreadMax; i++)
				{
					String value = Enum.GetName(typeof(HttpUtillityMethods), FMethod[i]);
					
					switch(value)
					{
						case "HtmlEncode": 
							FOutput[i] = HttpUtility.HtmlEncode(FInput[i]);
							break;
						case "HtmlDecode":
							FOutput[i] = HttpUtility.HtmlDecode(FInput[i]);
							break;
						case "UrlEncode": 
							FOutput[i] = HttpUtility.UrlEncode(FInput[i]);
							break;
						case "UrlEncodeUnicode":
							FOutput[i] = HttpUtility.UrlEncodeUnicode(FInput[i]);
							break;
						case "UrlDecode":
							FOutput[i] = HttpUtility.UrlDecode(FInput[i]);
							break;
					}
				}
			}
			
		}
	}
}
