#region usings
using System;
using System.ComponentModel.Composition;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Collections.Specialized;
using System.IO;
using System.IO.Compression;
//using System.Collections.Specialized;
using System.Text.RegularExpressions;
using System.Dynamic;
using System.Collections;
using System.Collections.ObjectModel;
using System.Net.Security;
using System.Web;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "TwitterAPI_Requests", Category = "String", Help = "HTTP GET with modified headers", Tags = "twitter", Author = "Soundreactor")]
	#endregion PluginInfo
	public class StringTwitterAPI_RequestsNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("obtain", IsBang = true)]
		ISpread<bool> FInput;
		
		[Input("URL", DefaultString = "https://api.twitter.com/oauth2/token")]
		ISpread<string> FInput2;
		
		[Input("BearerToken")]
		ISpread<string> FInput3;
		
		[Input("PostData")]
		ISpread<string> FInput4;

		[Output("Output")]
		ISpread<string> FOutput;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = SpreadMax;

			if(FInput[0] == true)
			{
			
				
							
				string sURL;
				sURL = FInput2[0];
	
				WebRequest wrGETURL;
				wrGETURL = WebRequest.Create(sURL);
			
				
				wrGETURL.Headers.Add("Authorization", FInput3[0]);
				//wrGETURL.Headers.Add("Accept-Encoding", "gzip");	
				
							
				FLogger.Log(LogType.Debug,"\nThe HttpHeaders are \n\n\tName\t\tValue\n{0}",wrGETURL.Headers);
				
				
				
				//WebProxy myProxy = new WebProxy("myproxy",80);
				//myProxy.BypassProxyOnLocal = true;
	
		       // wrGETURL.Proxy = WebProxy.GetDefaultProxy();
	
				Stream objStream;
				objStream = wrGETURL.GetResponse().GetResponseStream();
	
				StreamReader objReader = new StreamReader(objStream);
	
				string sLine = "";
				int i = 0;
	
				FOutput[0] = objReader.ReadToEnd().Trim();
				
		
						
					
			
		
				
				
			}
		}
	}
}
