﻿using FarseerPhysics.Dynamics;
using FarseerPhysics.Dynamics.Contacts;
using System;
using VL.Lib.Reactive;

namespace FarseerHelper
{
    public class CollisionEvent
    {
        public readonly Contact Contact;
        public readonly Fixture FixtureA;
        public readonly Fixture FixtureB;

        public CollisionEvent(Fixture fixtureA, Fixture fixtureB, Contact contact)
        {
            FixtureA = fixtureA;
            FixtureB = fixtureB;
            Contact = contact;
        }

        public bool CancelCollision { get; set; }
    }

    public static class FarseerTests
    {
        public static IObservable<CollisionEvent> OnCollision(this Body body)
        {
            return ObservableNodes.FromEvent<OnCollisionEventHandler, CollisionEvent>(
                body,
                conversion: handler => (fixtureA, fixtureB, contact) =>
                {
                    var e = new CollisionEvent(fixtureA, fixtureB, contact);
                    handler(e);
                    return !e.CancelCollision;
                },
                addHandler: handler => body.OnCollision += handler,
                removeHandler: handler => body.OnCollision -= handler);
        }
    }
}
