Name "vvvv-Installer"
!define INSTALLATIONNAME "vvvv-Installer"
OutFile "vvvv-Installer.exe"


;all Included Librarys here:
!include x64.nsh
!include MUI.nsh
!include DotNetChecker.nsh
!include LogicLib.nsh
!include FileFunc.nsh
!include zipdll.nsh

InstallDir C:\vvvv
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
 
;!insertmacro MUI_UNPAGE_CONFIRM
;!insertmacro MUI_UNPAGE_INSTFILES

!insertmacro MUI_LANGUAGE "English"

Var DirectXSetupError

;Request application privileges for Windows Vista, 7, 8
RequestExecutionLevel admin 
!addplugindir "..\Debug"
!addplugindir "."

; No need to compress twice!
SetCompress off



Section "CheckDotNet" CheckDotNet

  SetOutPath "$INSTDIR"
  
  !insertmacro CheckNetFramework 45

SectionEnd

Section "Install DX9 and redistributables" Installvvvvdependencies
;Check if we have DX9 installed
  SetOutPath "$INSTDIR"

  IfFileExists $WINDIR\System32\D3DX9_43.dll dx_found dx_not_found
  
  dx_found:
   DetailPrint "$WINDIR\System32\D3DX9_43.dll found"
   ${GetFileVersion} "$WINDIR\System32\D3DX9_43.dll" $R0
   DetailPrint "DX9 $R0 is installed"
  ${If} $R0 == "9.29.952.3111"
  ${Else}
  dx_not_found:
   MessageBox MB_OK "DX9 will be installed, you have to be online"

 
  SetOutPath "$TEMP"
  File "dxwebsetup.exe"
  DetailPrint "Running DirectX Setup..."
  ExecWait '"$TEMP\dxwebsetup.exe" /Q' $DirectXSetupError
  DetailPrint "Finished DirectX Setup"
 
  Delete "$TEMP\dxwebsetup.exe"
  ${EndIf}


;Check if we have redistributables installed

Call  Check2008SP132Installed
Pop $R1

${If} $R1 == "Error"
  File "vcredist_x86_2008.exe" 	
  ExecWait '"$INSTDIR\vcredist_x86_2008.exe" /passive /norestart'	
  Delete "$INSTDIR\vcredist_x86_2008.exe"
${EndIf}

Call  Check2010SP132Installed
Pop $R1

${If} $R1 == "Error"
  File "vcredist_x86_2010.exe" 	
  ExecWait '"$INSTDIR\vcredist_x86_2010.exe" /passive /norestart'	
  Delete "$INSTDIR\vcredist_x86_2010.exe"
${EndIf}

Call  Check201332Installed
Pop $R1

${If} $R1 == "Error"
  File "vcredist_x86_2013.exe" 	
  ExecWait '"$INSTDIR\vcredist_x86_2013.exe" /passive /norestart'	
  Delete "$INSTDIR\vcredist_x86_2013.exe"
${EndIf}

SectionEnd

Section "Install vvvv_45beta33.7_x86" Installvvvv

  
  SetOutPath "$INSTDIR" 
  DetailPrint "Extracting package..."
  SetDetailsPrint listonly
  
  File vvvv_45beta33.7_x86.zip
  !insertmacro ZIPDLL_EXTRACT "$INSTDIR\vvvv_45beta33.7_x86.zip" "$INSTDIR" "<ALL>"
    Delete "$OUTDIR\vvvv_45beta33.7_x86.zip"
  File addons_45beta33.7_x86.zip 
  !insertmacro ZIPDLL_EXTRACT "$INSTDIR\addons_45beta33.7_x86.zip" "$INSTDIR\vvvv_45beta33.7_x86" "<ALL>"
    Delete "$OUTDIR\addons_45beta33.7_x86.zip"
  File vvvv-packs-dx11-1.0.1-x86.zip 
  !insertmacro ZIPDLL_EXTRACT "$INSTDIR\vvvv-packs-dx11-1.0.1-x86.zip" "$INSTDIR\vvvv_45beta33.7_x86" "<ALL>"
    Delete "$OUTDIR\vvvv-packs-dx11-1.0.1-x86.zip"
    
SectionEnd
  
Section "Registry Entry AddFlow5" AddReg

   ;Add registry entry "AddFlow5" ->last step
  SetOutPath "$INSTDIR"
  SetOverwrite on
  Exec '"regsvr32.exe" "$INSTDIR\vvvv_45beta33.7_x86\lib\thirdparty\x86\AddFlow5.ocx"'
  
SectionEnd
  ;all Functions:
  
Function Check2008SP132Installed
  Push $R1
  ClearErrors
  
  SetRegView 32
  ReadRegDWORD $R1 HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{9A25302D-30C0-39D9-BD6F-21E6EC160475}" "Version"
  DetailPrint "2008 SP1 x86: $R1"
  ;was there an error or not?
  IfErrors 0 NoErrors
  ;error occured, copy "Error" to R0
  StrCpy $R1 "Error"
  DetailPrint "2008 SP1 x86: $R1"
  
  NoErrors:
  
  Exch $R1 
	
FunctionEnd

Function Check2010SP132Installed
  Push $R1
  ClearErrors
  
SetRegView 32
  ReadRegDWORD $R1 HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{F0C3E5D1-1ADE-321E-8167-68EF0DE699A5}" "Version"
   DetailPrint "2010 SP1 x86: $R1"
  ;was there an error or not?
  IfErrors 0 NoErrors
  ;error occured, copy "Error" to R0
  StrCpy $R1 "Error"
  DetailPrint "2010 SP1 x86: $R1"
  
  NoErrors:
  
  Exch $R1 
	
FunctionEnd

Function Check201332Installed
  Push $R1
  ClearErrors
  
SetRegView 32
  ReadRegDWORD $R1 HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{f65db027-aff3-4070-886a-0d87064aabb1}" "Installed"
   DetailPrint "2013 x86: $R1"
  ;was there an error or not?
  IfErrors 0 NoErrors
  ;error occured, copy "Error" to R0
  StrCpy $R1 "Error"
  DetailPrint "2013 x86: $R1"
  
  NoErrors:
  
  Exch $R1 
	
FunctionEnd
