#region licence/info

//////project name
//vvvv plugin template

//////description
//basic vvvv node plugin template.
//Copy this an rename it, to write your own plugin node.

//////licence
//GNU Lesser General Public License (LGPL)
//english: http://www.gnu.org/licenses/lgpl.html
//german: http://www.gnu.de/lgpl-ger.html

//////language/ide
//C# sharpdevelop

//////dependencies
//VVVV.PluginInterfaces.V1;
//VVVV.Utils.VColor;
//VVVV.Utils.VMath;

//////initial author
//vvvv group

#endregion licence/info

//use what you need
using System;
using System.Drawing;
using System.Collections;
using System.IO;

using VVVV.PluginInterfaces.V1;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using Sanford.Multimedia.Midi;

//the vvvv node namespace
namespace VVVV.Nodes
{
	
	//class definition
	public class MidiRead: IPlugin, IDisposable
	{
		#region field declaration
		
		//the host (mandatory)
		private IPluginHost FHost;
		// Track whether Dispose has been called.
		private bool FDisposed = false;

		//input pin declaration
		private IStringIn FFileNameInput;

		private IValueIn FReadInput;
		private IValueIn FTracksInput;
		
		//output pin declaration
		
		private IValueOut FTicks;
		private IValueOut FDivision;
		
		/*private IValueOut FChMsgTrack;
		private IValueOut FChMsgAbsTicks;
		private IValueOut FChMsgChannel;
		private IValueOut FChMsgCommand;
		private IValueOut FChMsgData1;
		private IValueOut FChMsgData2;
		 */
		
		private IValueOut FStartTime;
		private IValueOut FEndTime;
		private IValueOut FNote;
		private IValueOut FVelocity;
		private IValueOut FTrack;
		private IValueOut FChannel;
		
		#endregion field declaration
		
		#region constructor/destructor
		
		public MidiRead()
		{
			//the nodes constructor
			//nothing to declare for this node
		}
		
		// Implementing IDisposable's Dispose method.
		// Do not make this method virtual.
		// A derived class should not be able to override this method.
		public void Dispose()
		{
			Dispose(true);
			// Take yourself off the Finalization queue
			// to prevent finalization code for this object
			// from executing a second time.
			GC.SuppressFinalize(this);
		}
		
		// Dispose(bool disposing) executes in two distinct scenarios.
		// If disposing equals true, the method has been called directly
		// or indirectly by a user's code. Managed and unmanaged resources
		// can be disposed.
		// If disposing equals false, the method has been called by the
		// runtime from inside the finalizer and you should not reference
		// other objects. Only unmanaged resources can be disposed.
		protected virtual void Dispose(bool disposing)
		{
			// Check to see if Dispose has already been called.
			if(!FDisposed)
			{
				if(disposing)
				{
					// Dispose managed resources.
				}
				// Release unmanaged resources. If disposing is false,
				// only the following code is executed.
				
				FHost.Log(TLogType.Debug, "MidiRead is being deleted");
				
				// Note that this is not thread safe.
				// Another thread could start disposing the object
				// after the managed resources are disposed,
				// but before the disposed flag is set to true.
				// If thread safety is necessary, it must be
				// implemented by the client.
			}
			FDisposed = true;
		}

		// Use C# destructor syntax for finalization code.
		// This destructor will run only if the Dispose method
		// does not get called.
		// It gives your base class the opportunity to finalize.
		// Do not provide destructors in types derived from this class.
		~MidiRead()
		{
			// Do not re-create Dispose clean-up code here.
			// Calling Dispose(false) is optimal in terms of
			// readability and maintainability.
			Dispose(false);
		}
		#endregion constructor/destructor
		
		#region node name and infos
		
		//provide node infos
		private static IPluginInfo FPluginInfo;
		public static IPluginInfo PluginInfo
		{
			get
			{
				if (FPluginInfo == null)
				{
					//fill out nodes info
					//see: http://www.vvvv.org/tiki-index.php?page=Conventions.NodeAndPinNaming
					FPluginInfo = new PluginInfo();
					
					//the nodes main name: use CamelCaps and no spaces
					FPluginInfo.Name = "MidiRead";
					//the nodes category: try to use an existing one
					FPluginInfo.Category = "Spreads";
					//the nodes version: optional. leave blank if not
					//needed to distinguish two nodes of the same name and category
					FPluginInfo.Version = "Simple";
					
					//the nodes author: your sign
					FPluginInfo.Author = "vvvv group";
					//describe the nodes function
					FPluginInfo.Help = "Offers a basic code layout to start from when writing a vvvv plugin";
					//specify a comma separated list of tags that describe the node
					FPluginInfo.Tags = "";
					
					//give credits to thirdparty code used
					FPluginInfo.Credits = "";
					//any known problems?
					FPluginInfo.Bugs = "";
					//any known usage of the node that may cause troubles?
					FPluginInfo.Warnings = "";
					
					//leave below as is
					System.Diagnostics.StackTrace st = new System.Diagnostics.StackTrace(true);
					System.Diagnostics.StackFrame sf = st.GetFrame(0);
					System.Reflection.MethodBase method = sf.GetMethod();
					FPluginInfo.Namespace = method.DeclaringType.Namespace;
					FPluginInfo.Class = method.DeclaringType.Name;
					//leave above as is
				}
				return FPluginInfo;
			}
		}

		public bool AutoEvaluate
		{
			//return true if this node needs to calculate every frame even if nobody asks for its output
			get {return false;}
		}
		
		#endregion node name and infos
		
		#region pin creation
		
		//this method is called by vvvv when the node is created
		public void SetPluginHost(IPluginHost Host)
		{
			//assign host
			FHost = Host;

			//create inputs
			
			FHost.CreateStringInput("File Name", TSliceMode.Dynamic, TPinVisibility.True, out FFileNameInput);
			FFileNameInput.SetSubType("", true);

			FHost.CreateValueInput("Read", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FReadInput);
			FReadInput.SetSubType(double.MinValue, double.MaxValue, 0.01, 0.0, true, false, false);
			
			FHost.CreateValueInput("Tracks", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FTracksInput);
			FTracksInput.SetSubType(double.MinValue, double.MaxValue, 0.01, -1.0, false, false, false);
			
			//create outputs
			FHost.CreateValueOutput("Ticks", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FTicks);
			FTicks.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);
			
			FHost.CreateValueOutput("Division", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FDivision);
			FDivision.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);			
			
			/*FHost.CreateValueOutput("Channel Message Track", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FChMsgTrack);
			FChMsgTrack.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);
			
			FHost.CreateValueOutput("Channel Message Absolute Ticks", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FChMsgAbsTicks);
			FChMsgAbsTicks.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);

			FHost.CreateValueOutput("Channel Message Channel", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FChMsgChannel);
			FChMsgChannel.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);
			
			FHost.CreateValueOutput("Channel Message Command", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FChMsgCommand);
			FChMsgCommand.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);

			FHost.CreateValueOutput("Channel Message Data1", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FChMsgData1);
			FChMsgData1.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);

			FHost.CreateValueOutput("Channel Message Data2", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FChMsgData2);
			FChMsgData2.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);
			 */
			FHost.CreateValueOutput("Note Start Time", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FStartTime);
			FStartTime.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);
			
			FHost.CreateValueOutput("Note End Time", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FEndTime);
			FEndTime.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);

			FHost.CreateValueOutput("Note", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FNote);
			FNote.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);
			
			FHost.CreateValueOutput("Note Velocity", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FVelocity);
			FVelocity.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);

			FHost.CreateValueOutput("Note Track", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FTrack);
			FTrack.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);

			FHost.CreateValueOutput("Note Channel", 1, null, TSliceMode.Dynamic, TPinVisibility.True, out FChannel);
			FChannel.SetSubType(double.MinValue, double.MaxValue, 0.01, 0, false, false, false);
		}

		#endregion pin creation
		
		#region mainloop
		
		public void Configurate(IPluginConfig Input)
		{
			//nothing to configure in this plugin
			//only used in conjunction with inputs of type cmpdConfigurate
		}

		#region ChannelEvent struct
		struct ChannelEvent
		{
			public double Track;
			public double AbsTicks;
			public double Channel;
			public double Command;
			public double Data1;
			public double Data2;
		}
		
		#endregion ChannelEvent struct
		
		#region MidiNote struct
		struct MidiNote
		{
			public double StartTime;
			public double EndTime;
			public double Note;
			public double Velocity;
			public double Track;
			public double Channel;
		}
		#endregion MidiNote struct
		
		//here we go, thats the method called by vvvv each frame
		//all data handling should be in here
		public void Evaluate(int SpreadMax)
		{
			//if any of the inputs has changed
			//recompute the outputs
			
			bool ReadFile = false;
			double ReadIn = 0.0;
			FReadInput.GetValue(0, out ReadIn);

			string FileName;
			FFileNameInput.GetString(0, out FileName);
			
			if( ( FFileNameInput.PinIsChanged || FReadInput.PinIsChanged ) && ( ReadIn > 0.5 ) )
			{
				FileInfo MidFileInfo = new FileInfo(FileName);

				ReadFile = MidFileInfo.Exists;
			}
			
			if ( ReadFile )
			{
				Sequence MididFile = new Sequence(FileName);
				
				//MididFile.Format;
				//MididFile.Count;
				
				SequenceType SeqType = MididFile.SequenceType;
				
				int Division = MididFile.Division;
				
				int EventCount = 0;
				int NoteCount = 0;
				
				ArrayList ChanMessages = new ArrayList();
				ArrayList Notes = new ArrayList();
				
				int[] NoteOnStatus = new int[128]; //To keep track of Note On/Off status for each possible Midi Note 0-127
				for(int i = 0; i < 128; i++) NoteOnStatus[i] = -1;
				
				
				#region loop through midi events
				for(int t = 0; t < MididFile.Count; t++)
				{
					EventCount += MididFile[t].Count;
					//MididFile[t].Length;
					
					for(int e = 0; e < MididFile[t].Count; e++)
					{
						MidiEvent mEvent = MididFile[t].GetMidiEvent(e);
						MessageType MsgType = mEvent.MidiMessage.MessageType;
						
						switch (MsgType)
						{
							case MessageType.Channel:
								
								ChannelMessage ChanMsg = (ChannelMessage) mEvent.MidiMessage;
								ChannelEvent ChanEvent = new ChannelEvent();
								
								ChanEvent.Track = (double) t;
								ChanEvent.AbsTicks = (double) mEvent.AbsoluteTicks;
								ChanEvent.Channel = (double) ChanMsg.MidiChannel;
								ChanEvent.Command = (double) ChanMsg.Command;
								ChanEvent.Data1 = (double) ChanMsg.Data1;
								ChanEvent.Data2 = (double) ChanMsg.Data2;
								
								ChanMessages.Add(ChanEvent);
								
								if(( ChanMsg.Command == ChannelCommand.NoteOn ) && ( ChanMsg.Data2 != 0) ) //Note On
								{
									
									MidiNote Note = new MidiNote();
									
									Note.StartTime = (double) mEvent.AbsoluteTicks;
									Note.EndTime = Note.StartTime + 1.0; //Todo: come up with a reasonable default value?
									Note.Note = (double) ChanMsg.Data1;
									Note.Velocity = (double) ChanMsg.Data2;
									Note.Track = (double) t;
									Note.Channel = (double) ChanMsg.MidiChannel;
									
									Notes.Add(Note);
									if(NoteOnStatus[ChanMsg.Data1] >= 0) //Same note is already on so turn the old one off first
									{
										MidiNote OldNote = new MidiNote();
										OldNote = (MidiNote) Notes[ NoteOnStatus[ChanMsg.Data1] ];
										OldNote.EndTime = Note.StartTime; // -1?
										Notes[ NoteOnStatus[ChanMsg.Data1] ] = OldNote;
									}
									
									NoteOnStatus[ChanMsg.Data1] = NoteCount;
									
									NoteCount++;
								}
								else if( (( ChanMsg.Command == ChannelCommand.NoteOn ) && ( ChanMsg.Data2 == 0) ) ||
								        ( ChanMsg.Command == ChannelCommand.NoteOff) ) //Note off
								{
									
									if(NoteOnStatus[ChanMsg.Data1] >= 0) // note is on so turn it off
									{
										MidiNote OldNote = new MidiNote();
										OldNote = (MidiNote) Notes[ NoteOnStatus[ChanMsg.Data1] ];
										OldNote.EndTime = (double) mEvent.AbsoluteTicks;
										Notes[ NoteOnStatus[ChanMsg.Data1] ] = OldNote;
										
										NoteOnStatus[ChanMsg.Data1] = -1;
									}
									
								}
								
								
								break;
								
							case MessageType.Meta:
								MetaMessage MetaMsg = (MetaMessage) mEvent.MidiMessage;
								
								break;

								#region no handling of these categories yet
//							case MessageType.SystemCommon:
//								;
//								break;
//
//							case MessageType.SystemExclusive:
//								;
//								break;
//
//							case MessageType.SystemRealtime: //clock/timing/sync related
//								;
//								break;
								#endregion nohandle
								
						} //switch (MsgType)
					} //for event
				} //for track
				#endregion loop through midievents

				
				#region pin output
				
				FTicks.SliceCount = 1;
				FTicks.SetValue(0, (double) MididFile.GetLength() );
				
				FDivision.SliceCount = 1;
				FDivision.SetValue(0, (double) Division);
				
				/*FChMsgTrack.SliceCount = ChanMessages.Count;
				FChMsgAbsTicks.SliceCount = ChanMessages.Count;
				FChMsgChannel.SliceCount = ChanMessages.Count;
				FChMsgCommand.SliceCount = ChanMessages.Count;
				FChMsgData1.SliceCount = ChanMessages.Count;
				FChMsgData2.SliceCount = ChanMessages.Count;
				
				for(int i = 0; i < ChanMessages.Count; i++)
				{
					ChannelEvent Evnt = (ChannelEvent) ChanMessages[i];
					FChMsgTrack.SetValue(i, Evnt.Track);
					FChMsgAbsTicks.SetValue(i, Evnt.AbsTicks);
					FChMsgChannel.SetValue(i, Evnt.Channel);
					FChMsgCommand.SetValue(i, Evnt.Command);
					FChMsgData1.SetValue(i, Evnt.Data1);
					FChMsgData2.SetValue(i, Evnt.Data2);
				} //for channel event
				 */
				FStartTime.SliceCount = Notes.Count;
				FEndTime.SliceCount = Notes.Count;
				FNote.SliceCount = Notes.Count;
				FVelocity.SliceCount = Notes.Count;
				FTrack.SliceCount = Notes.Count;
				FChannel.SliceCount = Notes.Count;
				
				for(int i = 0; i < Notes.Count; i++)
				{
					MidiNote Note = (MidiNote) Notes[i];
					FStartTime.SetValue(i, Note.StartTime);
					FEndTime.SetValue(i, Note.EndTime);
					FNote.SetValue(i, Note.Note);
					FVelocity.SetValue(i, Note.Velocity);
					FTrack.SetValue(i, Note.Track);
					FChannel.SetValue(i, Note.Channel);
				} //for channel event
				#endregion pin output

			} //if ReadFile
		} //Evaluate()
		
		#endregion mainloop
	}
}
