#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "gFantastickReader", Category = "String", Help = "Parse Fantastick Messages", Tags = "Fantastick")]
	#endregion PluginInfo
	public class StringgFantastickReaderNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultString = "")]
		ISpread<string> fInput;

		[Output("Output")]
		ISpread<string> FOutput;
		
		[Output("Bin Size")]
		ISpread<int> FBinSize;
		
		[Output("IP Address")]
		ISpread<string> FIpAddress;
		
		[Output("Touch Count")]
		ISpread<int> FTouchCount;
		
		[Output("Is Touching")]
		ISpread<bool> FIsTouching;
		
		[Output("Bang on Touch Begin")]
		ISpread<bool> FTouchBegin;
		
		[Output("Bang on Touch Move")]
		ISpread<bool> FTouchMove;
		
		[Output("Bang on Touch End")]
		ISpread<bool> FTouchEnd;
		
		[Output("Touch Position X")]
		ISpread<double> FTouchX;
		
		[Output("Touch Position Y")]
		ISpread<double> FTouchY;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		private const int MAX_TOUCHES = 5;
		
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			int slices = 0;
			int idx;
			
			FBinSize.SliceCount = fInput.SliceCount;
			FOutput.SliceCount = 99;
			
			FTouchBegin.SliceCount =
			FTouchMove.SliceCount = 
			FTouchEnd.SliceCount = 
			FTouchX.SliceCount = 
				FTouchY.SliceCount = 
				FIsTouching.SliceCount = MAX_TOUCHES;
			
			// reset bangs
			for (int i = 0; i<MAX_TOUCHES; i++) {
				FTouchBegin[i] = 
				FTouchMove[i] =
				FTouchEnd[i] = false;
			}
			
			//log("vvvvvvvvvvvvv");
			for (int i = 0; i < fInput.SliceCount; i++) {
				
				string[] words = fInput[i].Split(' ');
				//log("-------");
				
				for (int j = 0; j<words.Length; j++) {
					//log((slices+j) + "> "+  words[j]);
					FOutput[slices+j] = words[j];
				}
				
				string cmd = words[0];
				
				switch (cmd) {
					case "X":	// # of fingers touching screen
						FTouchCount[0] = Convert.ToInt16(words[1]);
						break;
						
					case "B":	// finger touch begin
						idx = Convert.ToInt16(words[3])-1;
						FIsTouching[idx] = true;
						FTouchBegin[idx] = true;
						//FTouchMove[idx] = false;
						//FTouchEnd[idx] = false;
						FTouchX[idx] = Convert.ToInt16(words[1]);
						FTouchY[idx] = Convert.ToInt16(words[2]);
						break;
						
					case "M":	// finger already touching moved
						idx = Convert.ToInt16(words[3])-1;
						FIsTouching[idx] = true;
						//FTouchBegin[idx] = false;
						FTouchMove[idx] = true;
						//FTouchEnd[idx] = false;
						FTouchX[idx] = Convert.ToInt16(words[1]);
						FTouchY[idx] = Convert.ToInt16(words[2]);
						break;
						
					case "E":	// finger touch end
						idx = Convert.ToInt16(words[3])-1;
						FIsTouching[idx] = false;
						//FTouchBegin[idx] = false;
						//FTouchMove[idx] = false;
						FTouchEnd[idx] = true;
						FTouchX[idx] = Convert.ToInt16(words[1]);
						FTouchY[idx] = Convert.ToInt16(words[2]);
						break;
						
					case "IP":
						FIpAddress[0] = words[1];
						break;
				}
				
				slices += words.Length;
				FBinSize[i] = words.Length;
			}
			
			FOutput.SliceCount = slices;
			
		}
		
		private void log(string s) {
			FLogger.Log(LogType.Debug, s);
		}
	}
}
