#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
    //create your own enum type or use any other .net enum
	public enum MyEnum
	{
		A,
		B,
		C
	}

	#region PluginInfo
	[PluginInfo(Name = "Template",
	            Category = "Enumerations",
	            Version = "Static",
	            Help = "Basic template with native .NET enum type",
	            Tags = "")]
	#endregion PluginInfo
	public class Template : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input")]
		IDiffSpread<MyEnum> FInput;

		[Output("Output")]
		ISpread<MyEnum> FOutput;

		[Import()]
		ILogger Flogger;
		#endregion fields & pins

		//called each frame by vvvv
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = SpreadMax;

			if (FInput.IsChanged) 
			{
				for (int i = 0; i < SpreadMax; i++)
					FOutput[i] = FInput[i];

				Flogger.Log(LogType.Debug, "Input was changed");
			}
		}
	}
}
