#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Template", 
	            Category = "Enumerations", 
	            Version = "Dynamic",
	            Help = "Basic template with dynamic custom enumeration",
	            Tags = "")]
	#endregion PluginInfo
	public class Template : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", EnumName = "MyDynamicEnum")]
		IDiffSpread<EnumEntry> FInput;

		[Output("Output", EnumName = "MyDynamicEnum")]
		ISpread<EnumEntry> FOutput;

		[Import()]
		ILogger Flogger;
		#endregion fields & pins
		
		//add some entries to the enum in the constructor
		public Template()
		{
		    var s = new string[]{"A", "B", "C"};
		    EnumManager.UpdateEnum("MyDynamicEnum", s[0], s);  
		}

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = SpreadMax;

			if (FInput.IsChanged) 
			{
				for (int i = 0; i < SpreadMax; i++)
					FOutput[i] = FInput[i];

				Flogger.Log(LogType.Debug, "Input was changed");
			}
		}
	}
}
